/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  alignment.cc - GtkAlignment C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "alignment.h"
#include "private/alignment_p.h"

using namespace Inti;

/*  Gtk::Alignment
 */

Gtk::Alignment::Alignment(GtkAlignment *alignment, bool reference)
: Bin((GtkBin*)alignment, reference)
{
}

Gtk::Alignment::Alignment()
: Bin((GtkBin*)AlignmentClass::create())
{
}

Gtk::Alignment::Alignment(float xalign, float yalign, float xscale, float yscale)
: Bin((GtkBin*)AlignmentClass::create())
{
	set(xalign, yalign, xscale, yscale);
}

Gtk::Alignment::~Alignment()
{
}

GtkAlignmentClass*
Gtk::Alignment::gtk_alignment_class() const
{
	return get_class<GtkAlignmentClass>();
}

Gtk::Alignment::operator GtkAlignment* () const
{
	return this ? gtk_alignment() : 0;
}

void
Gtk::Alignment::set(float xalign, float yalign, float xscale, float yscale)
{
	gtk_alignment_set(gtk_alignment(), xalign, yalign, xscale, yscale);
}

/*  Gtk::AlignmentClass
 */

void
Gtk::AlignmentClass::init(GtkAlignmentClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
}

GType
Gtk::AlignmentClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ALIGNMENT, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::AlignmentClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::Alignment::XAlignPropertyType Gtk::Alignment::xalign_property("xalign");

const Gtk::Alignment::YAlignPropertyType Gtk::Alignment::yalign_property("yalign");

const Gtk::Alignment::XScalePropertyType Gtk::Alignment::xscale_property("xscale");

const Gtk::Alignment::YScalePropertyType Gtk::Alignment::yscale_property("yscale");
