/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  checkbutton.cc - GtkCheckButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "checkbutton.h"
#include "private/checkbutton_p.h"

using namespace Inti;

/*  Gtk::CheckButton
 */

Gtk::CheckButton::CheckButton(GtkCheckButton *check_button, bool reference)
: ToggleButton((GtkToggleButton*)check_button, reference)
{
}

Gtk::CheckButton::CheckButton() 
: ToggleButton((GtkToggleButton*)CheckButtonClass::create())
{
}

Gtk::CheckButton::CheckButton(const String& label, bool use_underline)
: ToggleButton((GtkToggleButton*)CheckButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::CheckButton::~CheckButton()
{
}

GtkCheckButtonClass* 
Gtk::CheckButton::gtk_check_button_class() const
{ 
	return get_class<GtkCheckButtonClass>(); 
}
	
Gtk::CheckButton::operator GtkCheckButton* () const 
{ 
	return this ? gtk_check_button() : 0; 
}
	
/*  Gtk::CheckButtontClass
 */

void
Gtk::CheckButtonClass::init(GtkCheckButtonClass *g_class)
{
	ToggleButtonClass::init((GtkToggleButtonClass*)g_class);
	g_class->draw_indicator = &draw_indicator_proxy;
}

GType
Gtk::CheckButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CHECK_BUTTON, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CheckButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CheckButtonClass::draw_indicator_proxy(GtkCheckButton *check_button, GdkRectangle *area)
{
	CheckButton *tmp_check_button = G::Object::pointer<CheckButton>(check_button);
	if (tmp_check_button)
		tmp_check_button->do_draw_indicator(area);
	else
	{
		GtkCheckButtonClass *tmp_class = GTK_CHECK_BUTTON_GET_CLASS(check_button);
		GtkCheckButtonClass *g_class = G::TypeInstance::class_peek_parent<GtkCheckButtonClass>(tmp_class);
		if (g_class->draw_indicator)
			g_class->draw_indicator(check_button, area);
	}
}


/*  Overridable methods
 */

void
Gtk::CheckButton::do_draw_indicator(GdkRectangle *area)
{
	GtkCheckButtonClass *g_class = class_peek_parent<GtkCheckButtonClass>(gtk_check_button_class());
	if (g_class->draw_indicator)
		g_class->draw_indicator(gtk_check_button(), area);
}
