/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  misc.cc - GtkMisc C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "misc.h"
#include "private/misc_p.h"

using namespace Inti;

/*  Gtk::Misc
 */

Gtk::Misc::Misc(GtkMisc *misc, bool reference)
:  Widget((GtkWidget*)misc, reference)
{
}

Gtk::Misc::Misc()
: Widget((GtkWidget*)MiscClass::create())
{
}

Gtk::Misc::~Misc()
{
}

GtkMiscClass*
Gtk::Misc::gtk_misc_class() const 
{ 
	return get_class<GtkMiscClass>(); 
}
	
Gtk::Misc::operator GtkMisc* () const 
{ 
	return this ? gtk_misc() : 0; 
}
	
void
Gtk::Misc::get_alignment(float *xalign, float *yalign)
{
	gtk_misc_get_alignment(gtk_misc(), xalign, yalign);
}

void
Gtk::Misc::get_padding(int *xpad, int *ypad)
{
	gtk_misc_get_padding(gtk_misc(), xpad, ypad);
}

void
Gtk::Misc::set_alignment(float xalign, float yalign)
{
	gtk_misc_set_alignment(gtk_misc(), xalign, yalign);
}

void
Gtk::Misc::set_padding(int xpad, int ypad)
{
	gtk_misc_set_padding(gtk_misc(), xpad, ypad);
}

/*  Gtk::MiscClass
 */

void
Gtk::MiscClass::init(GtkMiscClass *g_class)
{
	WidgetClass::init((GtkWidgetClass*)g_class);
}

GType
Gtk::MiscClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_MISC, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::MiscClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::Misc::XAlignPropertyType Gtk::Misc::xalign_property("xalign");

const Gtk::Misc::YAlignPropertyType Gtk::Misc::yalign_property("yalign");

const Gtk::Misc::XPadPropertyType Gtk::Misc::xpad_property("xpad");

const Gtk::Misc::YPadPropertyType Gtk::Misc::ypad_property("ypad");


