/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  notebook.cc - GtkNotebook C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "notebook.h"
#include "private/notebook_p.h"
#include "label.h"

using namespace Inti;

/*  Gtk::Notebook
 */

Gtk::Notebook::Notebook(GtkNotebook *notebook, bool reference)
: Container((GtkContainer*)notebook, reference)
{
}

Gtk::Notebook::Notebook() 
: Container((GtkContainer*)NotebookClass::create())
{
}

Gtk::Notebook::~Notebook() 
{
}

GtkNotebookClass*
Gtk::Notebook::gtk_notebook_class() const 
{ 
	return get_class<GtkNotebookClass>(); 
}
	
Gtk::Notebook::operator GtkNotebook* () const 
{
	return this ? gtk_notebook() : 0; 
}
	
int
Gtk::Notebook::get_current_page() const
{
	return gtk_notebook_get_current_page(gtk_notebook());
}

Gtk::Widget*
Gtk::Notebook::get_current_nth_page() const
{
	return get_nth_page(get_current_page());
}

Gtk::Widget* 
Gtk::Notebook::get_nth_page(int page_num) const
{
	return G::Object::wrap<Widget>(gtk_notebook_get_nth_page(gtk_notebook(), page_num));
}

int 
Gtk::Notebook::get_n_pages() const
{
	return gtk_notebook_get_n_pages(gtk_notebook());
}

int
Gtk::Notebook::page_num(const Widget& child) const
{
	return gtk_notebook_page_num(gtk_notebook(), child.gtk_widget());
}

bool 
Gtk::Notebook::get_show_border() const
{
	return gtk_notebook_get_show_border(gtk_notebook());
}

bool 
Gtk::Notebook::get_show_tabs() const
{
	return gtk_notebook_get_show_tabs(gtk_notebook());
}

Gtk::PositionType 
Gtk::Notebook::get_tab_pos() const
{
	return (PositionType)gtk_notebook_get_tab_pos(gtk_notebook());
}

bool 
Gtk::Notebook::get_scrollable() const
{
	return gtk_notebook_get_scrollable(gtk_notebook());
}

Gtk::Label* 
Gtk::Notebook::get_tab_label(const Widget& child) const
{
	return G::Object::wrap<Label>((GtkLabel*)gtk_notebook_get_tab_label(gtk_notebook(), child.gtk_widget()));
}

Gtk::Label* 
Gtk::Notebook::get_tab_label(int page_num) const
{
	GtkWidget *tab_label = 0;
	GtkWidget *child = gtk_notebook_get_nth_page(gtk_notebook(), page_num);
	if (child)
		tab_label = gtk_notebook_get_tab_label(gtk_notebook(), child);
	return tab_label ? G::Object::wrap<Label>((GtkLabel*)tab_label) : 0;
}

String 
Gtk::Notebook::get_tab_label_text(const Widget& child) const
{
	return gtk_notebook_get_tab_label_text(gtk_notebook(), child.gtk_widget());
}

String 
Gtk::Notebook::get_tab_label_text(int page_num) const
{
	GtkWidget *child = gtk_notebook_get_nth_page(gtk_notebook(), page_num);
	return gtk_notebook_get_tab_label_text(gtk_notebook(), child);
}

Gtk::Label* 
Gtk::Notebook::get_menu_label(const Widget& child) const
{
	return G::Object::wrap<Label>((GtkLabel*)gtk_notebook_get_menu_label(gtk_notebook(), child.gtk_widget()));
}

Gtk::Label* 
Gtk::Notebook::get_menu_label(int page_num) const
{
	GtkWidget *menu_label = 0;
	GtkWidget *child = gtk_notebook_get_nth_page(gtk_notebook(), page_num);
	if (child)
		menu_label = gtk_notebook_get_menu_label(gtk_notebook(), child);
	return menu_label ? G::Object::wrap<Label>((GtkLabel*)menu_label) : 0;
}

String 
Gtk::Notebook::get_menu_label_text(const Widget& child) const
{
	return gtk_notebook_get_menu_label_text(gtk_notebook(), child.gtk_widget());
}

String 
Gtk::Notebook::get_menu_label_text(int page_num) const
{
	GtkWidget *child = gtk_notebook_get_nth_page(gtk_notebook(), page_num);
	return gtk_notebook_get_menu_label_text(gtk_notebook(), child);
}

void 
Gtk::Notebook::query_tab_label_packing(const Widget& child, bool *expand, bool *fill, PackType *pack_type) const
{
	gtk_notebook_query_tab_label_packing(gtk_notebook(), child.gtk_widget(), (gboolean*)expand, (gboolean*)fill, (GtkPackType*)pack_type);
}

void
Gtk::Notebook::append_page(Widget& child, Widget *tab_label, Widget *menu_label)
{
	gtk_notebook_append_page_menu(gtk_notebook(), child.gtk_widget(), *tab_label, *menu_label);
}

void
Gtk::Notebook::append_page(Widget& child, const String& tab_label, const String& menu_label)
{
	gtk_notebook_append_page_menu(gtk_notebook(), child.gtk_widget(), 0, 0);
	set_tab_label_text(child, tab_label);
	if (!menu_label.null())
		set_menu_label_text(child, menu_label);
}

void 
Gtk::Notebook::prepend_page(Widget& child, Widget *tab_label, Widget *menu_label)
{
	gtk_notebook_prepend_page_menu(gtk_notebook(), child.gtk_widget(), *tab_label, *menu_label);
}

void 
Gtk::Notebook::prepend_page(Widget& child, const String& tab_label, const String& menu_label)
{
	gtk_notebook_prepend_page_menu(gtk_notebook(), child.gtk_widget(), 0, 0);
	set_tab_label_text(child, tab_label);
	if (!menu_label.null())
		set_menu_label_text(child, menu_label);
}

void 
Gtk::Notebook::insert_page(Widget& child, int position, Widget *tab_label, Widget *menu_label)
{
	gtk_notebook_insert_page_menu(gtk_notebook(), child.gtk_widget(), *tab_label, *menu_label, position);
}

void 
Gtk::Notebook::insert_page(Widget& child, int position, const String& tab_label, const String& menu_label)
{
	gtk_notebook_insert_page_menu(gtk_notebook(), child.gtk_widget(), 0, 0, position);
	set_tab_label_text(child, tab_label);
	if (!menu_label.null())
		set_menu_label_text(child, menu_label);
}

void 
Gtk::Notebook::remove_page(int page_num)
{
	gtk_notebook_remove_page(gtk_notebook(), page_num);
}

void 
Gtk::Notebook::set_current_page(int page_num)
{
	gtk_notebook_set_current_page(gtk_notebook(), page_num);
}

void 
Gtk::Notebook::next_page()
{
	gtk_notebook_next_page(gtk_notebook());
}

void 
Gtk::Notebook::prev_page()
{
	gtk_notebook_prev_page(gtk_notebook());
}

void 
Gtk::Notebook::set_show_border(bool show_border)
{
	gtk_notebook_set_show_border(gtk_notebook(), show_border);
}

void 
Gtk::Notebook::set_show_tabs(bool show_tabs)
{
	gtk_notebook_set_show_tabs(gtk_notebook(), show_tabs);
}

void 
Gtk::Notebook::set_tab_pos(PositionType pos)
{
	gtk_notebook_set_tab_pos(gtk_notebook(), (GtkPositionType)pos);
}

void 
Gtk::Notebook::set_scrollable(bool scrollable)
{
	gtk_notebook_set_scrollable(gtk_notebook(), scrollable);
}

void
Gtk::Notebook::popup_enable()
{
	gtk_notebook_popup_enable(gtk_notebook());
}

void 
Gtk::Notebook::popup_disable()
{
	gtk_notebook_popup_disable(gtk_notebook());
}

void 
Gtk::Notebook::set_tab_label(Widget& child, Widget *tab_label)
{
	gtk_notebook_set_tab_label(gtk_notebook(), child.gtk_widget(), *tab_label);
}

void 
Gtk::Notebook::set_tab_label_text(Widget& child, const String& tab_text)
{
	gtk_notebook_set_tab_label_text(gtk_notebook(), child.gtk_widget(), tab_text.c_str());
}

void 
Gtk::Notebook::set_menu_label(Widget& child, Widget *menu_label)
{
	gtk_notebook_set_menu_label(gtk_notebook(), child.gtk_widget(), *menu_label);
}

void
Gtk::Notebook::set_menu_label_text(Widget& child, const String& menu_text)
{
	gtk_notebook_set_menu_label_text(gtk_notebook(), child.gtk_widget(), menu_text.c_str());
}

void
Gtk::Notebook::set_tab_label_packing(Widget& child, bool expand, bool fill, PackType pack_type)
{
	gtk_notebook_set_tab_label_packing(gtk_notebook(), child.gtk_widget(), expand, fill, (GtkPackType)pack_type);
}

void 
Gtk::Notebook::reorder_child(Widget& child, int position)
{
	gtk_notebook_reorder_child(gtk_notebook(), child.gtk_widget(), position);
}

/*  Gtk::NotebookClass
 */

void
Gtk::NotebookClass::init(GtkNotebookClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
	g_class->switch_page = &switch_page_proxy;
}

GType
Gtk::NotebookClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_NOTEBOOK, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::NotebookClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::NotebookClass::switch_page_proxy(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num)
{
	Notebook *tmp_notebook = G::Object::pointer<Notebook>(notebook);
	if (tmp_notebook)
		tmp_notebook->on_switch_page(page, page_num);
	else
	{
		GtkNotebookClass *g_class = G::TypeInstance::class_peek_parent<GtkNotebookClass>(GTK_NOTEBOOK_GET_CLASS(notebook));
		if (g_class->switch_page)
			g_class->switch_page(notebook, page, page_num);
	}
}

/*  Signal handlers
 */

void
Gtk::Notebook::on_switch_page(GtkNotebookPage *page, unsigned int page_num)
{
	GtkNotebookClass *g_class = class_peek_parent<GtkNotebookClass>(gtk_notebook_class());
	if (g_class->switch_page)
		g_class->switch_page(gtk_notebook(), page, page_num);
}

/*  Properties
 */

const Gtk::Notebook::PagePropertyType Gtk::Notebook::page_property("page");

const Gtk::Notebook::TabPosPropertyType Gtk::Notebook::tab_pos_property("tab_pos");

const Gtk::Notebook::TabBorderPropertyType Gtk::Notebook::tab_border_property("tab_border");

const Gtk::Notebook::TabHBorderPropertyType Gtk::Notebook::tab_hborder_property("tab_hborder");

const Gtk::Notebook::TabVBorderPropertyType Gtk::Notebook::tab_vborder_property("tab_vborder");

const Gtk::Notebook::ShowTabsPropertyType Gtk::Notebook::show_tabs_property("show_tabs");

const Gtk::Notebook::ShowBorderPropertyType Gtk::Notebook::show_border_property("show_border");

const Gtk::Notebook::ScrollablePropertyType Gtk::Notebook::scrollable_property("scrollable");

const Gtk::Notebook::EnablePopupPropertyType Gtk::Notebook::enable_popup_property("enable_popup");

const Gtk::Notebook::HomogeneousPropertyType Gtk::Notebook::homogeneous_property("homogeneous");

/*  Child properties
 */

const Gtk::Notebook::TabLabelPropertyType Gtk::Notebook::tab_label_property("tab_label");

const Gtk::Notebook::MenuLabelPropertyType Gtk::Notebook::menu_label_property("menu_label");

const Gtk::Notebook::PositionPropertyType Gtk::Notebook::position_property("position");

const Gtk::Notebook::TabExpandPropertyType Gtk::Notebook::tab_expand_property("tab_expand");

const Gtk::Notebook::TabFillPropertyType Gtk::Notebook::tab_fill_property("tab_fill");

const Gtk::Notebook::TabPackPropertyType Gtk::Notebook::tab_pack_property("tab_pack");

/*  Signals
 */

const Gtk::Notebook::SwitchPageSignalType Gtk::Notebook::switch_page_signal("switch_page");

