/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  plug.cc - GtkPlug C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "plug.h"
#include "private/plug_p.h"
#include "socket.h"
#include "../gdk/display.h"
#include "../gdk/window.h"

using namespace Inti;

/*  Gtk::Plug
 */

Gtk::Plug::Plug(GtkPlug *plug, bool reference)
: Window((GtkWindow*)plug, reference)
{
}

Gtk::Plug::Plug(GdkNativeWindow socket_id, const Gdk::Display *display)
: Window((GtkWindow*)PlugClass::create())
{
	GdkDisplay *tmp_display = display ? display->gdk_display() : gdk_display_get_default();
	gtk_plug_construct_for_display(gtk_plug(), tmp_display, socket_id);
}

Gtk::Plug::~Plug()
{
}

GtkPlugClass*
Gtk::Plug::gtk_plug_class() const 
{
	return get_class<GtkPlugClass>(); 
}

Gtk::Plug::operator GtkPlug* () const 
{ 
	return this ? gtk_plug() : 0; 
}
	
bool
Gtk::Plug::has_socket() const
{
	return GDK_IS_WINDOW(gtk_plug()->socket_window);
}

Gdk::Window*
Gtk::Plug::socket_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_plug()->socket_window);
}

bool 
Gtk::Plug::same_app() const
{
	return gtk_plug()->same_app;
}
	
GdkNativeWindow 
Gtk::Plug::get_id() const
{
	return gtk_plug_get_id(gtk_plug());
}

void
Gtk::Plug::add_to_socket(Socket& socket)
{
 	_gtk_plug_add_to_socket(gtk_plug(), socket.gtk_socket());
}

void 
Gtk::Plug::remove_from_socket(Socket& socket)
{
	_gtk_plug_remove_from_socket(gtk_plug(), socket.gtk_socket());
}

/*  Gtk::PlugClass
 */

void
Gtk::PlugClass::init(GtkPlugClass *g_class)
{
	WindowClass::init((GtkWindowClass*)g_class);
	g_class->embedded = &embedded_proxy;
}

GType
Gtk::PlugClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_PLUG, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::PlugClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::PlugClass::embedded_proxy(GtkPlug *plug)
{
	Plug *tmp_plug = G::Object::pointer<Plug>(plug);
	if (tmp_plug)
		tmp_plug->on_embedded();
	else
	{
		GtkPlugClass *g_class = G::TypeInstance::class_peek_parent<GtkPlugClass>(GTK_PLUG_GET_CLASS(plug));
		if (g_class->embedded)
			g_class->embedded(plug);
	}
}

/*  Signal handlers
 */

void
Gtk::Plug::on_embedded()
{
	GtkPlugClass *g_class = class_peek_parent<GtkPlugClass>(gtk_plug_class());
	if (g_class->embedded)
		g_class->embedded(gtk_plug());
}

/*  Signals
 */

const Gtk::Plug::EmbeddedSignalType Gtk::Plug::embedded_signal("embedded");

