/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  treesortable_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_TREE_SORTABLE_IFACE_H
#define INTI_GTK_TREE_SORTABLE_IFACE_H

namespace Inti {

namespace Gtk {

class TreeSortableIface
{
public:
	static void init(GtkTreeSortableIface *g_iface);

// Methods
	static gboolean get_sort_column_id_proxy(GtkTreeSortable *sortable, gint *sort_column_id, GtkSortType *order);

	static void set_sort_column_id_proxy(GtkTreeSortable *sortable, gint sort_column_id, GtkSortType order);

	static void set_sort_func_proxy(GtkTreeSortable *sortable, gint sort_column_id, GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy);

	static void  set_default_sort_func_proxy(GtkTreeSortable *sortable, GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy);

	static gboolean has_default_sort_func_proxy(GtkTreeSortable *sortable);

// Signals
	static void sort_column_changed_proxy(GtkTreeSortable *sortable);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_TREE_SORTABLE_IFACE_H

