/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  window_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_WINDOW_CLASS_H
#define INTI_GTK_WINDOW_CLASS_H

#include <inti/gtk/private/bin_p.h>

namespace Inti {

namespace Gtk {

/*  Gtk::WindowClass
 */

class WindowClass
{
public:
	static void init(GtkWindowClass *g_class);

	static GType get_type();

	static void* create();

	static void set_focus_proxy(GtkWindow *window, GtkWidget *focus);

	static gboolean frame_event_proxy(GtkWindow *window, GdkEvent *event);

	static void keys_changed_proxy(GtkWindow *window);
	
	static gboolean delete_event_proxy(GtkWidget *widget, GdkEventAny *event);
};

/*  Gtk::WindowGroupClass
 */

class WindowGroupClass
{
public:
	static void init(GtkWindowGroupClass *g_class);

	static GType get_type();

	static void* create();
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_WINDOW_CLASS_H

