/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  table.cc - GtkTable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "table.h"
#include "private/table_p.h"

using namespace Inti;

/*  Gtk::Table
 */

Gtk::Table::Table(GtkTable *table, bool reference)
: Container((GtkContainer*)table, reference)
{
}

Gtk::Table::Table(unsigned int rows, unsigned int columns, bool homogeneous) 
: Container((GtkContainer*)TableClass::create())
{
	resize(rows, columns);
	set_homogeneous(homogeneous);
}

Gtk::Table::~Table() 
{
}
	
GtkTableClass* 
Gtk::Table::gtk_table_class() const 
{ 
	return get_class<GtkTableClass>(); 
}
	
Gtk::Table::operator GtkTable* () const 
{ 
	return this ? gtk_table() : 0; 
}

unsigned int
Gtk::Table::get_row_spacing(unsigned int row) const
{
	return gtk_table_get_row_spacing(gtk_table(), row);
}


unsigned int
Gtk::Table::get_column_spacing(unsigned int column) const
{
	return gtk_table_get_col_spacing(gtk_table(), column);
}

unsigned int
Gtk::Table::get_default_row_spacing() const
{
	return gtk_table_get_default_row_spacing(gtk_table());
}

unsigned int
Gtk::Table::get_default_col_spacing() const
{
	return gtk_table_get_default_col_spacing(gtk_table());
}

bool 
Gtk::Table::get_homogeneous() const
{
	return gtk_table_get_homogeneous(gtk_table());
}

void 
Gtk::Table::resize(unsigned int rows, unsigned int columns)
{
	gtk_table_resize(gtk_table(), rows, columns);
}

void 
Gtk::Table::attach(Widget& child, unsigned int left_attach, unsigned int right_attach, unsigned int top_attach, unsigned int bottom_attach,
                   AttachOptionsField xoptions, AttachOptionsField yoptions, unsigned int xpadding, unsigned int ypadding)
{
	gtk_table_attach(gtk_table(), child.gtk_widget(), left_attach, right_attach, top_attach, bottom_attach, 
	                 (GtkAttachOptions)xoptions, (GtkAttachOptions)yoptions, xpadding, ypadding);
}

void 
Gtk::Table::set_row_spacing(unsigned int row, unsigned int spacing)
{
	gtk_table_set_row_spacing(gtk_table(), row, spacing);
}

void 
Gtk::Table::set_col_spacing(unsigned int column, unsigned int spacing)
{
	gtk_table_set_col_spacing(gtk_table(), column, spacing);
}

void 
Gtk::Table::set_row_spacings(unsigned int spacing)
{
	gtk_table_set_row_spacings(gtk_table(), spacing);
}

void 
Gtk::Table::set_col_spacings(unsigned int spacing)
{
	gtk_table_set_col_spacings(gtk_table(), spacing);
}

void 
Gtk::Table::set_spacings(unsigned int row_spacing, unsigned int col_spacing)
{
	set_row_spacings(row_spacing);
	set_col_spacings(col_spacing);
}

void 
Gtk::Table::set_homogeneous(bool homogeneous)
{
	gtk_table_set_homogeneous(gtk_table(), homogeneous);
}

/*  Gtk::TableClass
 */

void
Gtk::TableClass::init(GtkTableClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
}

GType
Gtk::TableClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TABLE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::TableClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::Table::NRowsPropertyType Gtk::Table::n_rows_property("n_rows");

const Gtk::Table::NColumnsPropertyType Gtk::Table::n_columns_property("n_columns");

const Gtk::Table::RowSpacingPropertyType Gtk::Table::row_spacing_property("row_spacing");

const Gtk::Table::ColumnSpacingPropertyType Gtk::Table::column_spacing_property("column_spacing");

const Gtk::Table::HomogeneousPropertyType Gtk::Table::homogeneous_property("homogeneous");

/*  Child properties
 */

const Gtk::Table::LeftAttachPropertyType Gtk::Table::left_attach_property("left_attach");

const Gtk::Table::RightAttachPropertyType Gtk::Table::right_attach_property("right_attach");

const Gtk::Table::TopAttachPropertyType Gtk::Table::top_attach_property("top_attach");

const Gtk::Table::BottomAttachPropertyType Gtk::Table::bottom_attach_property("bottom_attach");

const Gtk::Table::XOptionsPropertyType Gtk::Table::x_options_property("x_options");

const Gtk::Table::YOptionsPropertyType Gtk::Table::y_options_property("y_options");

const Gtk::Table::XPaddingPropertyType Gtk::Table::x_padding_property("x_padding");

const Gtk::Table::YPaddingPropertyType Gtk::Table::y_padding_property("y_padding");

