#include <libnjb.h>
#include <getopt.h>

extern int njb_error;

int main(int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	extern char *optarg;
	int opt;
	int i, n, debug;
	/* eax_t *eax; - deprecated API */
	njb_eax_t *eax;

	debug = 0;
	while ((opt = getopt(argc, argv, "D:")) != -1) {
		switch (opt) {
		case 'D':
			debug = atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: dumpeax [ -D debuglvl ]\n");
			return 1;
		}
	}

	if (debug)
		NJB_Set_Debug(debug);

	if (NJB_Discover(njbs, 0, &n) == -1)
		njb_error_dump(stderr);

	if (n == 0) {
		fprintf(stderr, "no NJB devices found\n");
		return 0;
	}

	njb = njbs;

	if (NJB_Open(njb) == -1) {
		njb_error_dump(stderr);
		return 1;
	}

	if (NJB_Capture(njb) == -1) {
		njb_error_dump(stderr);
		return 1;
	}


	NJB_Reset_Get_EAX_Type (njb);
	
	while ((eax = NJB_Get_EAX_Type (njb)) != NULL) {
	  printf("------------------------------------------\n");
	  printf("Effect number: %04X\n", eax->number);
	  printf("Effect name: %s\n", eax->name);
	  printf("Effect group %d\n", eax->group);
	  if (eax->exclusive != 0x00) {
	    printf("Effect is exclusive\n");
	  }
	  if (eax->selectable != 0x00) {
	    printf("Effect has selectable patches:\n");
	    printf("    Current selection: %d\n", eax->current_selectionvalue);
	    for(i = 0; i < eax->max_selectionvalue - eax->min_selectionvalue + 1; i++) {
	      printf("    %d. %s\n", eax->min_selectionvalue+i, eax->selection_names[i]);
	    }
	  }
	  if (eax->scaleable != 0x00) {
	    printf("Effect is scaleable:\n");
	    printf("    Current value: %d\n", eax->current_scalevalue);
	    printf("    Min value: %d\n", eax->min_scalevalue);
	    printf("    Max value %d\n", eax->max_scalevalue);
	  }	  
	  NJB_Destroy_EAX_Type (eax);
	}


	/* Deprecated API */
	/*
	eax = NJB_Get_EAX(njb);
	if (eax != NULL) {
		printf("Volume: %u\n", eax->volume);
		printf("Volume min: %u\n", eax->volumemin);
		printf("Volume max: %u\n", eax->volumemax);
		printf("Muted: %s\n", eax->muted ? "yes" : "no");
		printf("EQ Active: %s\n", eax->eq_status ? "yes" : "no");
		printf("Bass: %d\n", eax->bass);
		printf("Bass min: %d\n", eax->bassmin);
		printf("Bass max: %d\n", eax->bassmax);
		printf("Midrange: %d\n", eax->midrange);
		printf("Midrange min: %d\n", eax->midrangemin);
		printf("Midrange max: %d\n", eax->midrangemax);
		printf("Treble: %d\n", eax->treble);
		printf("Treble min: %d\n", eax->treblemin);
		printf("Treble max: %d\n", eax->treblemax);
		printf("Number of Equalizer midrange frequencies: %u\n",
			eax->nfreq);
		printf("Midrange frequency setting: %u\n", eax->freqset);
		printf("Midrange frequencies:\n");
		for (i = 0; i < eax->nfreq; i++) {
			printf("\t%u. %d\n", i, eax->frequencies[i]);
		}
		printf("Number of effects: %u\n", eax->neffects);
		printf("Active effect: %u\n", eax->acteffect);
		printf("Effects:\n");
		for (i = 0; i < eax->neffects; i++) {
			printf("\t%u. %s (amount: %u)\n", i,
				eax->effects[i], eax->effamts[i]);
		}
		printf("Number of headphone modes: %u\n", eax->nphone);
		printf("Active headphone mode: %u\n", eax->actphone);
		printf("Headphone modes:\n");
		for (i = 0; i < eax->nphone; i++) {
			printf("\t%u. %s\n", i, eax->phonemodes[i]);
		}
		printf("Number of rear modes: %u\n", eax->nrear);
		printf("Active rear mode: %u\n", eax->actrear);
		printf("Rear modes:\n");
		for (i = 0; i < eax->nrear; i++) {
			printf("\t%u. %s\n", i, eax->rears[i]);
		}
		eax_destroy(eax);
	}
	*/

	if (njb_error != EO_EOM)
		njb_error_dump(stderr);

	NJB_Release(njb);

	NJB_Close(njb);
	return 0;
}
