/*
 * Ostatnia aktualizacja:
 *
 * - $Id: hub.c,v 1.6 2003/05/10 20:12:25 pp Exp $
 *
 */

#include "libtlen.h"

/*
 * tlen_connect_server()
 *
 * czy si z serwerem
 *
 * - host - adres
 * - port - port
 *
 * Wewntrzna funkcja dla resolvera huba
 *
 */

int tlen_connect_server(const char* host, int port)
{
  struct hostent *h;
  tlen_debug("Resolving %s...\n", host);
  if ((h=gethostbyname(host))!=NULL) {
    int s;
    struct sockaddr_in sa;
    memset(&sa, 0, sizeof(sa));
    sa.sin_family=h->h_addrtype;
    sa.sin_port=htons(port);
    memcpy(&sa.sin_addr,h->h_addr,h->h_length);
    tlen_debug("Creating socket...\n");
    if ((s = socket(h->h_addrtype, SOCK_STREAM, IPPROTO_TCP))!=-1)
    {
      tlen_debug("Connecting...\n");
      if (connect (s, (struct sockaddr*)&sa, sizeof(sa))!=-1) {
        return s;
      } else tlen_debug("Connection failed !\n");
    } else tlen_debug("Socket creation failed !\n");
    close(s);
  } else tlen_debug("DNS lookup failed !\n");
  return 0;
}

#define HTTP_MAX_RESPONSE_LEN 8192

/*
 * tlen_hub_query()
 *
 * Tworzy i wysya zapytanie do huba
 *
 * - user - nazwa uytkownika
 *
 * Funkcja wewntrzna resolvera huba
 * Zwraca gotow, przeparsowan odpowied jako xmlnode
 *
 */

xmlnode tlen_hub_query (const char* user)
{
  xmlnode rv = NULL;
  char* uname_e=tlen_encode(user);
  int s=tlen_connect_server(TLEN_HUB, 80);
  if (s)
  {
    if (uname_e)
    {
      char *format="GET /4starters.php?u=%s&v=10 HTTP/1.0\r\nHost: %s\r\n\r\n";
      int format_len=strlen(format)+strlen(uname_e)+strlen(TLEN_HUB)-4+1;
      char *query=malloc(format_len);
      if (query)
      {
        sprintf(query, format, uname_e, TLEN_HUB);
        tlen_debug("Sending query...\n%s\n",query);

        if (write(s, query, format_len-1) == (format_len-1))
        {
// Pobieranie odpowiedzi
          char response[HTTP_MAX_RESPONSE_LEN+1];
          int amount;
          if ((amount = read(s, response, HTTP_MAX_RESPONSE_LEN))!=-1)
          {
// Parsowanie HTTP
            char* header=strstr(response,"\r\n");
            char* body=strstr(response,"\r\n\r\n");
	    response[amount]=0;

            tlen_debug("%s\n", response);

            if ((header!=NULL) && (body!=NULL))
            {
              *header='\0';
              body+=4;
              if (strstr(response," 200 "))
              {
// Parsowanie XML-a
                tlen_debug("Parsing response...\n");
                rv = xmlstr2xmlnode(body);
              }
            }
          }
        }
        free(query);
      }
      free(uname_e);
    }
    close(s);
  }
  return rv;
}

// tlen_find_server
// --
// znajduje adres i port serwera z ktrym mona si poczy
// zwraca NULL lub string z adresem serwera

/* 
 * tlen_find_server()
 *
 * Znajduje adres i port serwera z ktrym mona si poczy
 *
 * - username - nazwa uytkownika
 * - port - port (wskanik!)
 *
 * Funkcja wewntrzna do resolvera huba
 * Zwraca adres i port (w zmiennej port) serwera
 *
 */

char* tlen_find_server (const char* username, int* port)
{
  char* addr=malloc(INET_ADDRSTRLEN);
  if (addr)
  {
    struct hostent *h;
    xmlnode root;

    if ((root = tlen_hub_query(username)) != NULL)
    {
      char* server=xmlnode_get_attrib(root,"s");
      *port=atoi(xmlnode_get_attrib(root,"p"));
      tlen_debug("Got server %s, port %d\n",server,*port);
      tlen_debug("Resolving %s...\n",server);

      if ((h=gethostbyname(server))!=NULL)
      {
        if (inet_ntop(h->h_addrtype,h->h_addr,addr,INET_ADDRSTRLEN)) 
        {
          xmlnode_free(root);
          return addr;
        }
      }
      xmlnode_free(root);
    }

// Z hubem si co nie udao, prbujemy bezporednio

    tlen_debug("Fallback to %s:%d...\n", TLEN_FALLBACK_SERVER, TLEN_FALLBACK_PORT);

    if ((h=gethostbyname(TLEN_FALLBACK_SERVER))!=NULL)
    {
      if (inet_ntop(h->h_addrtype,h->h_addr,addr,INET_ADDRSTRLEN)) 
      {
        *port=TLEN_FALLBACK_PORT;
        return addr;
      }
    }
    
    free(addr);
  }
  tlen_debug("Resolver error !\n");
  return NULL;
}

/*
 * tlen_connect_hub_process()
 *
 * Tworzy i obsuguje proces czenia z hubem
 *
 * - user - nazwa uytkownika
 * - pipe - rrka
 *
 * Funkcja wewntrzna resolvera huba
 *
 */

void tlen_connect_hub_process (const char* user, int pipe)
{
  int port=0, len=0;
  char* addr;

  if ((addr=tlen_find_server(user, &port))!=NULL)
  {
    len=strlen(addr);
    write(pipe,&len,sizeof(len));
    if (len>0) {
      write(pipe,addr,len);
      write(pipe,&port,sizeof(port));
    }
    close(pipe);
    free(addr);
  } else {
    write(pipe,&len,sizeof(len));
    close(pipe);
  }
}

/*
 * tlen_connect_hub()
 *
 * czy si z hubem
 *
 * - sess - sesja
 * - blocking - blokowalne, lub nie
 *
 * jeli blocking=0 uruchamia proces czcy si w tle z hubem
 * jeli blocking=1 pobiera z huba serwer i si z nim czy
 * wywoywana z tlen_login
 * 
 */

int tlen_connect_hub (struct tlen_session *sess, int blocking)
{
  if (blocking)
  {
    char* addr;
    int port=0;
    if ((addr=tlen_find_server(sess->username, &port))==NULL) return -1;

    if ((sess->fd = tlen_socket_create (addr, port)) == -1) {
      tlen_debug ("Estabilishing connection to %s failed !\n", addr);
      free(addr);
      return -1;
    } else {
      sess->state = TLEN_STATE_CONNECTING;
      sess->check = TLEN_CHECK_WRITE;
    }
    free(addr);
  }
  else
  {
    int pipes[2], pid;

    if (pipe(pipes)==-1) return -1;
    if ((pid=fork())==-1) return -1;

    if (!pid) {
      tlen_connect_hub_process(sess->username, pipes[1]); 
      _exit(0);
    }

    close(pipes[1]);
    sess->fd=pipes[0];
    sess->resolv_pid=pid;
    sess->state = TLEN_STATE_CONNECTING_HUB;
    sess->check = TLEN_CHECK_READ;
  }
  return 0;
}
