/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc;

import java.sql.*;
import java.math.BigDecimal;
import java.util.Calendar;
import java.sql.Array;
import java.sql.Ref;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Map;
import java.net.URL;

import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.MessageKey;

/**
 *
 */
public class MemoryResultSetSapDB
        extends ConnectionItem
        implements java.sql.ResultSet
{
    private String [] colHeadings;
    private Object [][] rows;
    private int currentRow;
    private boolean lastWasNull;
/**
 * MemortResultSetSapDBTech constructor comment.
 */
public MemoryResultSetSapDB (
    String [] colHeadings,
    Object [] [] rows)
{
    super(null);
    this.colHeadings = colHeadings;
    this.rows = rows;
    this.currentRow = -1;
    this.lastWasNull = false;
}
/**
 * JDBC 2.0
 *
 * <p>Moves the cursor to the given row number in the result set.
 *
 * <p>If the row number is positive, the cursor moves to
 * the given row number with respect to the
 * beginning of the result set.  The first row is row 1, the second
 * is row 2, and so on.
 *
 * <p>If the given row number is negative, the cursor moves to
 * an absolute row position with respect to
 * the end of the result set.  For example, calling
 * <code>absolute(-1)</code> positions the
 * cursor on the last row, <code>absolute(-2)</code> indicates the next-to-last
 * row, and so on.
 *
 * <p>An attempt to position the cursor beyond the first/last row in
 * the result set leaves the cursor before/after the first/last
 * row, respectively.
 *
 * <p>Note: Calling <code>absolute(1)</code> is the same
 * as calling <code>first()</code>.
 * Calling <code>absolute(-1)</code> is the same as calling <code>last()</code>.
 *
 * @return true if the cursor is on the result set; false otherwise
 * @exception java.sql.SQLException if a database access error occurs or
 * row is 0, or result set type is TYPE_FORWARD_ONLY.
 */
    public boolean absolute( int row ) 
        throws java.sql.SQLException 
    {
        throwNotSupportedMethod("absolute");
        return false;
    }
    
    /**
     * JDBC 2.0
     *
     * <p>Moves the cursor to the end of the result set, just after the last
     * row.  Has no effect if the result set contains no rows.
     *
     * @exception java.sql.SQLException if a database access error occurs or the
     * result set type is TYPE_FORWARD_ONLY
     */
    public void afterLast() 
        throws java.sql.SQLException 
    {
        throwNotSupportedMethod("afterLast");
    }
    
    /**
     * JDBC 2.0
     *
     * <p>Moves the cursor to the front of the result set, just before the
     * first row. Has no effect if the result set contains no rows.
     *
     * @exception java.sql.SQLException if a database access error occurs or the
     * result set type is TYPE_FORWARD_ONLY
     */
    public void beforeFirst() throws java.sql.SQLException 
    {
        throwNotSupportedMethod("beforeFirst");
    }
    
/**
 * JDBC 2.0
 *
 * Cancels the updates made to a row.
 * This method may be called after calling an
 * <code>updateXXX</code> method(s) and before calling <code>updateRow</code> to rollback
 * the updates made to a row.  If no updates have been made or
 * <code>updateRow</code> has already been called, then this method has no
 * effect.
 *
 * @exception java.sql.SQLException if a database access error occurs or if
 * called when on the insert row
 *
 */
    public void cancelRowUpdates() 
        throws java.sql.SQLException 
    {
        throwNotSupportedMethod("cancelRowUpdates");
    }
    
/**
 * close method comment.
 */
public void close() throws SQLException {
}
/**
 * JDBC 2.0
 *
 * Deletes the current row from the result set and the underlying
 * database.  Cannot be called when on the insert row.
 *
 * @exception java.sql.SQLException if a database access error occurs or if
 * called when on the insert row.
 */
    public void deleteRow() 
        throws java.sql.SQLException 
    {
        throwNotSupportedMethod("deleteRow");
    }
    
/**
 * findColumn method comment.
 */
public int findColumn(String columnName) throws SQLException {
    for (int i = 0; i < this.colHeadings.length; ++i) {
        if (this.colHeadings [i].equals (columnName)) {
            return i + 1;
        }
    }
    throw new InvalidColumnException (columnName, this);
}
/**
 * JDBC 2.0
 *
 * <p>Moves the cursor to the first row in the result set.
 *
 * @return true if the cursor is on a valid row; false if
 *         there are no rows in the result set
 * @exception java.sql.SQLException if a database access error occurs or the
 * result set type is TYPE_FORWARD_ONLY
 */
    public boolean first() throws java.sql.SQLException {
        throwNotSupportedMethod("first");
        return false;
    }
/**
 * JDBC 2.0
 *
 * Gets an SQL ARRAY value from the current row of this <code>ResultSet</code> object.
 *
 * @param i the first column is 1, the second is 2, ...
 * @return an <code>Array</code> object representing the SQL ARRAY value in
 *         the specified column
 */
public Array getArray(int i) throws java.sql.SQLException {
    throw new NotSupportedException 
        (MessageTranslator.translate(MessageKey.ERROR_ARRAY_UNSUPPORTED),
         this);
}
/**
 * JDBC 2.0
 *
 * Gets an SQL ARRAY value in the current row of this <code>ResultSet</code> object.
 *
 * @param colName the name of the column from which to retrieve the value
 * @return an <code>Array</code> object representing the SQL ARRAY value in
 *         the specified column
 */
public Array getArray(String colName) throws java.sql.SQLException {
    throw new NotSupportedException 
        (MessageTranslator.translate(MessageKey.ERROR_ARRAY_UNSUPPORTED),
         this);

}
/**
 * getAsciiStream method comment.
 */
public java.io.InputStream getAsciiStream(int columnIndex) throws SQLException {
    return null;
}
/**
 * getAsciiStream method comment.
 */
public java.io.InputStream getAsciiStream(String columnName) throws SQLException {
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets the value of a column in the current row as a java.math.BigDecimal
 * object with full precision.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @return the column value (full precision); if the value is SQL NULL,
 * the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
public java.math.BigDecimal getBigDecimal(int columnIndex) throws java.sql.SQLException {
    throwNotSupportedMethod("getBigDecimal");
    return null;
}
/**
 * getBigDecimal method comment.
 */
public java.math.BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets the value of a column in the current row as a java.math.BigDecimal
 * object with full precision.
 * @param columnName the column name
 * @return the column value (full precision); if the value is SQL NULL,
 * the result is null
 * @exception java.sql.SQLException if a database access error occurs
 *
 */
public java.math.BigDecimal getBigDecimal(String columnName) throws java.sql.SQLException {
    throwNotSupportedMethod("getBigDecimal");
    return null;
}
/**
 * getBigDecimal method comment.
 */
public java.math.BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
    return null;
}
/**
 * getBinaryStream method comment.
 */
public java.io.InputStream getBinaryStream(int columnIndex) throws SQLException {
    return null;
}
/**
 * getBinaryStream method comment.
 */
public java.io.InputStream getBinaryStream(String columnName) throws SQLException {
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets a BLOB value in the current row of this <code>ResultSet</code> object.
 *
 * @param i the first column is 1, the second is 2, ...
 * @return a <code>Blob</code> object representing the SQL BLOB value in
 *         the specified column
 */
public Blob getBlob(int i) throws java.sql.SQLException {
    throwNotSupportedMethod("getBlob");
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets a BLOB value in the current row of this <code>ResultSet</code> object.
 *
 * @param colName the name of the column from which to retrieve the value
 * @return a <code>Blob</code> object representing the SQL BLOB value in
 *         the specified column
 */
public Blob getBlob(String colName) throws java.sql.SQLException {
    throwNotSupportedMethod("getBlob");
    return null;
}
/**
 * getBoolean method comment.
 */
public boolean getBoolean(int columnIndex) throws SQLException {
    return false;
}
/**
 * getBoolean method comment.
 */
public boolean getBoolean(String columnName) throws SQLException {
    return false;
}
/**
 * getByte method comment.
 */
public byte getByte(int columnIndex) throws SQLException {
    return (byte) 0;
}
/**
 * getByte method comment.
 */
public byte getByte(String columnName) throws SQLException {
    return (byte) 0;
}
/**
 * getBytes method comment.
 */
public byte[] getBytes(int columnIndex) throws SQLException {
    return null;
}
/**
 * getBytes method comment.
 */
public byte[] getBytes(String columnName) throws SQLException {
    return null;
}
//--------------------------JDBC 2.0-----------------------------------

//---------------------------------------------------------------------
// Getter's and Setter's
//---------------------------------------------------------------------

/**
 * JDBC 2.0
 *
 * <p>Gets the value of a column in the current row as a java.io.Reader.
 * @param columnIndex the first column is 1, the second is 2, ...
 */
public java.io.Reader getCharacterStream(int columnIndex) throws java.sql.SQLException {
    throwNotSupportedMethod("getCharacterStream");
    return null;
}
/**
 * JDBC 2.0
 *
 * <p>Gets the value of a column in the current row as a java.io.Reader.
 * @param columnName the name of the column
 * @return the value in the specified column as a <code>java.io.Reader</code>
 */
public java.io.Reader getCharacterStream(String columnName) throws java.sql.SQLException {
    throwNotSupportedMethod("getCharacterStream");
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets a CLOB value in the current row of this <code>ResultSet</code> object.
 *
 * @param i the first column is 1, the second is 2, ...
 * @return a <code>Clob</code> object representing the SQL CLOB value in
 *         the specified column
 */
public Clob getClob(int i) throws java.sql.SQLException {
    throwNotSupportedMethod("getClob"); 
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets a CLOB value in the current row of this <code>ResultSet</code> object.
 *
 * @param colName the name of the column from which to retrieve the value
 * @return a <code>Clob</code> object representing the SQL CLOB value in
 *         the specified column
 */
public Clob getClob(String colName) throws java.sql.SQLException {
    throwNotSupportedMethod("getClob"); 
    return null;
}
/**
 * JDBC 2.0
 *
 * Returns the concurrency mode of this result set.  The concurrency
 * used is determined by the statement that created the result set.
 *
 * @return the concurrency type, CONCUR_READ_ONLY or CONCUR_UPDATABLE
 * @exception java.sql.SQLException if a database access error occurs
 */
public int getConcurrency() throws java.sql.SQLException {
    throwNotSupportedMethod("getConcurrency"); 
    return 0;
}
/**
 * getCursorName method comment.
 */
public String getCursorName() throws SQLException {
    return "";
}
/**
 * getDate method comment.
 */
public Date getDate(int columnIndex) throws SQLException {
    return null;
}
/**
 * JDBC 2.0
 *
 * Gets the value of a column in the current row as a java.sql.Date
 * object. This method uses the given calendar to construct an appropriate millisecond
 * value for the Date if the underlying database does not store
 * timezone information.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param cal the calendar to use in constructing the date
 * @return the column value; if the value is SQL NULL, the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Date getDate(int columnIndex, java.util.Calendar cal) throws java.sql.SQLException {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_TIMEZONE_UNSUPPORTED),
             this);
    }
/**
 * getDate method comment.
 */
public Date getDate(String columnName) throws SQLException {
    return null;
}
/**
 * Gets the value of a column in the current row as a java.sql.Date
 * object. This method uses the given calendar to construct an appropriate millisecond
 * value for the Date, if the underlying database does not store
 * timezone information.
 *
 * @param columnName the SQL name of the column from which to retrieve the value
 * @param cal the calendar to use in constructing the date
 * @return the column value; if the value is SQL NULL, the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Date getDate(String columnName, java.util.Calendar cal) throws java.sql.SQLException {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_TIMEZONE_UNSUPPORTED),
             this);
    }
/**
 * getDouble method comment.
 */
public double getDouble(int columnIndex) throws SQLException {
    return 0;
}
/**
 * getDouble method comment.
 */
public double getDouble(String columnName) throws SQLException {
    return 0;
}
/**
 * JDBC 2.0
 *
 * Returns the fetch direction for this result set.
 *
 * @return the current fetch direction for this result set
 * @exception java.sql.SQLException if a database access error occurs
 */
public int getFetchDirection() throws java.sql.SQLException {
    throwNotSupportedMethod("getFetchDirection");
    return 0;
}
/**
 * JDBC 2.0
 *
 * Returns the fetch size for this result set.
 *
 * @return the current fetch size for this result set
 * @exception java.sql.SQLException if a database access error occurs
 */
public int getFetchSize() throws java.sql.SQLException {
    throwNotSupportedMethod("getFetchSize");
    return 0;
}
/**
 * getFloat method comment.
 */
public float getFloat(int columnIndex) throws SQLException {
    return 0;
}
/**
 * getFloat method comment.
 */
public float getFloat(String columnName) throws SQLException {
    return 0;
}
/**
 * getInt method comment.
 */
public int getInt(int columnIndex) throws SQLException {
    return 0;
}
/**
 * getInt method comment.
 */
public int getInt(String columnName) throws SQLException {
    return 0;
}
/**
 * getLong method comment.
 */
public long getLong(int columnIndex) throws SQLException {
    return 0;
}
/**
 * getLong method comment.
 */
public long getLong(String columnName) throws SQLException {
    return 0;
}
/**
 * getMetaData method comment.
 */
public ResultSetMetaData getMetaData() throws SQLException {
    return new MemoryResultSetMetaDataSapDB (this.colHeadings);
}
/**
 * getObject method comment.
 */
public Object getObject(int columnIndex) throws SQLException {
    Object result;

    try {
        result = this.rows [this.currentRow] [columnIndex - 1];
        this.lastWasNull = (result == null);
    }
    catch (ArrayIndexOutOfBoundsException exc) {
        throw new InvalidColumnException (columnIndex, this);
    }
    return result;
}
/**
 * JDBC 2.0
 *
 * Returns the value of a column in the current row as a Java object.
 * This method uses the given <code>Map</code> object
 * for the custom mapping of the
 * SQL structured or distinct type that is being retrieved.
 *
 * @param i the first column is 1, the second is 2, ...
 * @param map the mapping from SQL type names to Java classes
 * @return an object representing the SQL value
 */
    public Object getObject(int i, Map map) throws java.sql.SQLException {
        throwNotSupportedMethod("getObject");
        return null;
    }
/**
 * getObject method comment.
 */
public Object getObject(String columnName) throws SQLException {
    return this.getObject (this.findColumn (columnName));
}
/**
 * JDBC 2.0
 *
 * Returns the value in the specified column as a Java object.
 * This method uses the specified <code>Map</code> object for
 * custom mapping if appropriate.
 *
 * @param colName the name of the column from which to retrieve the value
 * @param map the mapping from SQL type names to Java classes
 * @return an object representing the SQL value in the specified column
 */
    public Object getObject(String colName, Map map) 
        throws java.sql.SQLException 
    {
        throwNotSupportedMethod("getObject");
        return null;
    }
/**
 * JDBC 2.0
 *
 * Gets a REF(&lt;structured-type&gt;) column value from the current row.
 *
 * @param i the first column is 1, the second is 2, ...
 * @return a <code>Ref</code> object representing an SQL REF value
 */
    public Ref getRef(int i) throws java.sql.SQLException {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_REF_UNSUPPORTED),
             this);
        
    }
/**
 * JDBC 2.0
 *
 * Gets a REF(&lt;structured-type&gt;) column value from the current row.
 *
 * @param colName the column name
 * @return a <code>Ref</code> object representing the SQL REF value in
 *         the specified column
 */
    public Ref getRef(String colName) throws java.sql.SQLException {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_REF_UNSUPPORTED),
             this);
    }
/**
 * JDBC 2.0
 *
 * <p>Retrieves the current row number.  The first row is number 1, the
 * second number 2, and so on.
 *
 * @return the current row number; 0 if there is no current row
 * @exception java.sql.SQLException if a database access error occurs
 */
    public int getRow() throws java.sql.SQLException {
        throwNotSupportedMethod("getRow");
        return 0;
    }
    
/**
 * getShort method comment.
 */
public short getShort(int columnIndex) throws SQLException {
    return (short) 0;
}
/**
 * getShort method comment.
 */
public short getShort(String columnName) throws SQLException {
    return (short) 0;
}
/**
 * JDBC 2.0
 *
 * Returns the Statement that produced this <code>ResultSet</code> object.
 * If the result set was generated some other way, such as by a
 * <code>DatabaseMetaData</code> method, this method returns <code>null</code>.
 *
 * @return the Statment that produced the result set or
 * null if the result set was produced some other way
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Statement getStatement() 
        throws java.sql.SQLException 
    {
        throwNotSupportedMethod("getStatement");
        return null;
    }
/**
 * getString method comment.
 */
public String getString(int columnIndex) throws SQLException {
    Object value;
    String result;

    value = this.getObject (columnIndex);
    if (value == null) {
        result = null;
    }
    else {
        result = value.toString ();
    }
    return result;
}
/**
 * getString method comment.
 */
public String getString(String columnName) throws SQLException {
    return this.getString (this.findColumn (columnName));
}
/**
 * getTime method comment.
 */
public Time getTime(int columnIndex) throws SQLException {
    return null;
}
/**
 * Gets the value of a column in the current row as a java.sql.Time
 * object. This method uses the given calendar to construct an appropriate millisecond
 * value for the Time if the underlying database does not store
 * timezone information.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param cal the calendar to use in constructing the time
 * @return the column value; if the value is SQL NULL, the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Time getTime(int columnIndex, Calendar cal) throws java.sql.SQLException {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_TIMEZONE_UNSUPPORTED),
             this);
        
}
/**
 * getTime method comment.
 */
public Time getTime(String columnName) throws SQLException {
    return null;
}
/**
 * Gets the value of a column in the current row as a java.sql.Time
 * object. This method uses the given calendar to construct an appropriate millisecond
 * value for the Time if the underlying database does not store
 * timezone information.
 *
 * @param columnName the SQL name of the column
 * @param cal the calendar to use in constructing the time
 * @return the column value; if the value is SQL NULL, the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Time getTime(String columnName, Calendar cal) throws java.sql.SQLException {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_TIMEZONE_UNSUPPORTED),
             this);
    }
/**
 * getTimestamp method comment.
 */
public Timestamp getTimestamp(int columnIndex) throws SQLException {
    return null;
}
/**
 * Gets the value of a column in the current row as a java.sql.Timestamp
 * object. This method uses the given calendar to construct an appropriate millisecond
 * value for the Timestamp if the underlying database does not store
 * timezone information.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param cal the calendar to use in constructing the timestamp
 * @return the column value; if the value is SQL NULL, the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Timestamp getTimestamp(int columnIndex, Calendar cal)
        throws java.sql.SQLException 
    {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_TIMEZONE_UNSUPPORTED),
             this);
    }
    
/**
 * getTimestamp method comment.
 */
public Timestamp getTimestamp(String columnName) throws SQLException {
    return null;
}
/**
 * Gets the value of a column in the current row as a java.sql.Timestamp
 * object. This method uses the given calendar to construct an appropriate millisecond
 * value for the Timestamp if the underlying database does not store
 * timezone information.
 *
 * @param columnName the SQL name of the column
 * @param cal the calendar to use in constructing the timestamp
 * @return the column value; if the value is SQL NULL, the result is null
 * @exception java.sql.SQLException if a database access error occurs
 */
    public java.sql.Timestamp getTimestamp(String columnName, Calendar cal)
        throws SQLException
    {
        throw new NotSupportedException 
            (MessageTranslator.translate(MessageKey.ERROR_TIMEZONE_UNSUPPORTED),
             this);
    }
    
/**
 * JDBC 2.0
 *
 * Returns the type of this result set.  The type is determined by
 * the statement that created the result set.
 *
 * @return TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, or
 * TYPE_SCROLL_SENSITIVE
 * @exception java.sql.SQLException if a database access error occurs
 */
    public int getType() throws java.sql.SQLException 
    {
        throwNotSupportedMethod("getType");
        return 0;
    }
/**
 * getUnicodeStream method comment.
 */
public java.io.InputStream getUnicodeStream(int columnIndex) throws SQLException {
    return null;
}
/**
 * getUnicodeStream method comment.
 */
public java.io.InputStream getUnicodeStream(String columnName) throws SQLException {
    return null;
}
/**
 * JDBC 2.0
 *
 * Inserts the contents of the insert row into the result set and
 * the database.  Must be on the insert row when this method is called.
 *
 * @exception java.sql.SQLException if a database access error occurs,
 * if called when not on the insert row, or if not all of non-nullable columns in
 * the insert row have been given a value
 */
    public void insertRow() throws java.sql.SQLException {
        throwNotSupportedMethod("insertRow");
    }
/**
 * JDBC 2.0
 *
 * <p>Indicates whether the cursor is after the last row in the result
 * set.
 *
 * @return true if the cursor is  after the last row, false otherwise.  Returns
 * false when the result set contains no rows.
 * @exception java.sql.SQLException if a database access error occurs
 */
public boolean isAfterLast() throws java.sql.SQLException {
        throwNotSupportedMethod("isAfterLast");
        return false;
}
//---------------------------------------------------------------------
// Traversal/Positioning
//---------------------------------------------------------------------

/**
 * JDBC 2.0
 *
 * <p>Indicates whether the cursor is before the first row in the result
 * set.
 *
 * @return true if the cursor is before the first row, false otherwise. Returns
 * false when the result set contains no rows.
 * @exception java.sql.SQLException if a database access error occurs
 */
public boolean isBeforeFirst() throws java.sql.SQLException {
        throwNotSupportedMethod("isBeforeFirst");
        return false;
}
/**
 * JDBC 2.0
 *
 * <p>Indicates whether the cursor is on the first row of the result set.
 *
 * @return true if the cursor is on the first row, false otherwise.
 * @exception java.sql.SQLException if a database access error occurs
 */
public boolean isFirst() throws java.sql.SQLException {
        throwNotSupportedMethod("isFirst");
        return false;
}
/**
 * JDBC 2.0
 *
 * <p>Indicates whether the cursor is on the last row of the result set.
 * Note: Calling the method <code>isLast</code> may be expensive
 * because the JDBC driver
 * might need to fetch ahead one row in order to determine
 * whether the current row is the last row in the result set.
 *
 * @return true if the cursor is on the last row, false otherwise.
 * @exception java.sql.SQLException if a database access error occurs
 */
public boolean isLast() throws java.sql.SQLException {
        throwNotSupportedMethod("isLast");
        return false;
}
/**
 * JDBC 2.0
 *
 * <p>Moves the cursor to the last row in the result set.
 *
 * @return true if the cursor is on a valid row;
 * false if there are no rows in the result set
 * @exception java.sql.SQLException if a database access error occurs or the
 * result set type is TYPE_FORWARD_ONLY.
 */
public boolean last() throws java.sql.SQLException {
    throwNotSupportedMethod("last");
    return false;
}
/**
 * JDBC 2.0
 *
 * Moves the cursor to the remembered cursor position, usually the
 * current row.  This method has no effect if the cursor is not on the insert
 * row.
 *
 * @exception java.sql.SQLException if a database access error occurs
 * or the result set is not updatable
 */
public void moveToCurrentRow() throws java.sql.SQLException {
    throwNotSupportedMethod("moveToCurrentRow");
}
/**
 * JDBC 2.0
 *
 * Moves the cursor to the insert row.  The current cursor position is
 * remembered while the cursor is positioned on the insert row.
 *
 * The insert row is a special row associated with an updatable
 * result set.  It is essentially a buffer where a new row may
 * be constructed by calling the <code>updateXXX</code> methods prior to
 * inserting the row into the result set.
 *
 * Only the <code>updateXXX</code>, <code>getXXX</code>,
 * and <code>insertRow</code> methods may be
 * called when the cursor is on the insert row.  All of the columns in
 * a result set must be given a value each time this method is
 * called before calling <code>insertRow</code>.
 * The method <code>updateXXX</code> must be called before a
 * <code>getXXX</code> method can be called on a column value.
 *
 * @exception java.sql.SQLException if a database access error occurs
 * or the result set is not updatable
 */
public void moveToInsertRow() throws java.sql.SQLException {
    throwNotSupportedMethod("moveToInsertRow");
}
/**
 * next method comment.
 */
public boolean next() throws SQLException {
    boolean result;

    if (this.currentRow < this.rows.length - 1) {
        ++this.currentRow;
        result = true;
    }
    else {
        result = false;
    }
    return result;
}
/**
 * JDBC 2.0
 *
 * <p>Moves the cursor to the previous row in the result set.
 *
 * <p>Note: <code>previous()</code> is not the same as
 * <code>relative(-1)</code> because it
 * makes sense to call</code>previous()</code> when there is no current row.
 *
 * @return true if the cursor is on a valid row; false if it is off the result set
 * @exception java.sql.SQLException if a database access error occurs or the
 * result set type is TYPE_FORWARD_ONLY
 */
public boolean previous() throws java.sql.SQLException {
    throwNotSupportedMethod("previous");
    return false;
}
/**
 * JDBC 2.0
 *
 * Refreshes the current row with its most recent value in
 * the database.  Cannot be called when on the insert row.
 *
 * The <code>refreshRow</code> method provides a way for an application to
 * explicitly tell the JDBC driver to refetch a row(s) from the
 * database.  An application may want to call <code>refreshRow</code> when
 * caching or prefetching is being done by the JDBC driver to
 * fetch the latest value of a row from the database.  The JDBC driver
 * may actually refresh multiple rows at once if the fetch size is
 * greater than one.
 *
 * All values are refetched subject to the transaction isolation
 * level and cursor sensitivity.  If <code>refreshRow</code> is called after
 * calling <code>updateXXX</code>, but before calling <code>updateRow</code>, then the
 * updates made to the row are lost.  Calling the method <code>refreshRow</code> frequently
 * will likely slow performance.
 *
 * @exception java.sql.SQLException if a database access error occurs or if
 * called when on the insert row
 */
public void refreshRow() throws java.sql.SQLException {
    throwNotSupportedMethod("refreshRow");
}
/**
 * JDBC 2.0
 *
 * <p>Moves the cursor a relative number of rows, either positive or negative.
 * Attempting to move beyond the first/last row in the
 * result set positions the cursor before/after the
 * the first/last row. Calling <code>relative(0)</code> is valid, but does
 * not change the cursor position.
 *
 * <p>Note: Calling <code>relative(1)</code>
 * is different from calling <code>next()</code>
 * because is makes sense to call <code>next()</code> when there is no current row,
 * for example, when the cursor is positioned before the first row
 * or after the last row of the result set.
 *
 * @return true if the cursor is on a row; false otherwise
 * @exception java.sql.SQLException if a database access error occurs, there
 * is no current row, or the result set type is TYPE_FORWARD_ONLY
 */
public boolean relative( int rows ) throws java.sql.SQLException {
    throwNotSupportedMethod("relative");
    return false;
}
/**
 * JDBC 2.0
 *
 * Indicates whether a row has been deleted.  A deleted row may leave
 * a visible "hole" in a result set.  This method can be used to
 * detect holes in a result set.  The value returned depends on whether
 * or not the result set can detect deletions.
 *
 * @return true if a row was deleted and deletions are detected
 * @exception java.sql.SQLException if a database access error occurs
 *
 * @see DatabaseMetaData#deletesAreDetected
 */
public boolean rowDeleted() throws java.sql.SQLException {
    throwNotSupportedMethod("rowDeleted");
    return false;
}
/**
 * JDBC 2.0
 *
 * Indicates whether the current row has had an insertion.  The value returned
 * depends on whether or not the result set can detect visible inserts.
 *
 * @return true if a row has had an insertion and insertions are detected
 * @exception java.sql.SQLException if a database access error occurs
 *
 * @see DatabaseMetaData#insertsAreDetected
 */
    public boolean rowInserted() throws java.sql.SQLException {
        throwNotSupportedMethod("rowInserted");
        return false;
    }
//---------------------------------------------------------------------
// Updates
//---------------------------------------------------------------------

/**
 * JDBC 2.0
 *
 * Indicates whether the current row has been updated.  The value returned
 * depends on whether or not the result set can detect updates.
 *
 * @return true if the row has been visibly updated by the owner or
 * another, and updates are detected
 * @exception java.sql.SQLException if a database access error occurs
 *
 * @see DatabaseMetaData#updatesAreDetected
 */
    public boolean rowUpdated() throws java.sql.SQLException {
        throwNotSupportedMethod("rowUpdated");
        return false;
    }
/**
 * JDBC 2.0
 *
 * Gives a hint as to the direction in which the rows in this result set
 * will be processed.  The initial value is determined by the statement
 * that produced the result set.  The fetch direction may be changed
 * at any time.
 *
 * @exception java.sql.SQLException if a database access error occurs or
 * the result set type is TYPE_FORWARD_ONLY and the fetch direction is not
 * FETCH_FORWARD.
 */
public void setFetchDirection(int direction) throws java.sql.SQLException {
    throwNotSupportedMethod("setFetchDirection");
}
/**
 * JDBC 2.0
 *
 * Gives the JDBC driver a hint as to the number of rows that should
 * be fetched from the database when more rows are needed for this result
 * set.  If the fetch size specified is zero, the JDBC driver
 * ignores the value and is free to make its own best guess as to what
 * the fetch size should be.  The default value is set by the statement
 * that created the result set.  The fetch size may be changed at any
 * time.
 *
 * @param rows the number of rows to fetch
 * @exception java.sql.SQLException if a database access error occurs or the
 * condition 0 <= rows <= this.getMaxRows() is not satisfied.
 */
public void setFetchSize(int rows) throws java.sql.SQLException {
    throwNotSupportedMethod("setFetchSize");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an ascii stream value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @param length the length of the stream
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateAsciiStream(int columnIndex,
                   java.io.InputStream x,
                   int length) throws java.sql.SQLException {
    throwNotSupportedMethod("updateAsciiStream");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an ascii stream value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @param length of the stream
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateAsciiStream(String columnName,
                   java.io.InputStream x,
                   int length) throws java.sql.SQLException {
    throwNotSupportedMethod("updateAsciiStream");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a BigDecimal value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBigDecimal(int columnIndex, BigDecimal x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBigDecimal");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a BigDecimal value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBigDecimal(String columnName, BigDecimal x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBigDecimal");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a binary stream value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @param length the length of the stream
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBinaryStream(int columnIndex,
                    java.io.InputStream x,
                    int length) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBinaryStream");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a binary stream value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @param length of the stream
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBinaryStream(String columnName,
                    java.io.InputStream x,
                    int length) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBinaryStream");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a boolean value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBoolean(int columnIndex, boolean x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBoolean");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a boolean value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBoolean(String columnName, boolean x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBoolean");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a byte value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateByte(int columnIndex, byte x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateByte");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a byte value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateByte(String columnName, byte x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateByte");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a byte array value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBytes(int columnIndex, byte x[]) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBytes");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a byte array value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateBytes(String columnName, byte x[]) throws java.sql.SQLException {
    throwNotSupportedMethod("updateBytes");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a character stream value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @param length the length of the stream
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateCharacterStream(int columnIndex,
                     java.io.Reader x,
                     int length) throws java.sql.SQLException {
    throwNotSupportedMethod("updateCharacterStream");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a character stream value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @param length of the stream
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateCharacterStream(String columnName,
                     java.io.Reader reader,
                     int length) throws java.sql.SQLException {
    throwNotSupportedMethod("updateCharacterStream");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Date value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateDate(int columnIndex, java.sql.Date x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateDate");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Date value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateDate(String columnName, java.sql.Date x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateDate");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Double value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateDouble(int columnIndex, double x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateDouble");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a double value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateDouble(String columnName, double x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateDouble");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a float value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateFloat(int columnIndex, float x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateFloat");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a float value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateFloat(String columnName, float x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateFloat");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an integer value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateInt(int columnIndex, int x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateInt");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an integer value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateInt(String columnName, int x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateInt");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a long value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateLong(int columnIndex, long x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateLong");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a long value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateLong(String columnName, long x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateLong");
}
/**
 * JDBC 2.0
 *
 * Give a nullable column a null value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateNull(int columnIndex) throws java.sql.SQLException {
    throwNotSupportedMethod("updateNull");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a null value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateNull(String columnName) throws java.sql.SQLException {
    throwNotSupportedMethod("updateNull");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an Object value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateObject(int columnIndex, Object x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateObject");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an Object value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
 *  this is the number of digits after the decimal.  For all other
 *  types this value will be ignored.
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateObject(int columnIndex, Object x, int scale)
  throws java.sql.SQLException {
    throwNotSupportedMethod("updateObject");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an Object value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateObject(String columnName, Object x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateObject");
}
/**
 * JDBC 2.0
 *
 * Updates a column with an Object value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
 *  this is the number of digits after the decimal.  For all other
 *  types this value will be ignored.
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateObject(String columnName, Object x, int scale)
  throws java.sql.SQLException {
    throwNotSupportedMethod("updateObject");
}
/**
 * JDBC 2.0
 *
 * Updates the underlying database with the new contents of the
 * current row.  Cannot be called when on the insert row.
 *
 * @exception java.sql.SQLException if a database access error occurs or
 * if called when on the insert row
 */
public void updateRow() throws java.sql.SQLException {
    throwNotSupportedMethod("updateRow");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a short value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateShort(int columnIndex, short x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateShort");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a short value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateShort(String columnName, short x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateShort");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a String value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateString(int columnIndex, String x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateString");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a String value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateString(String columnName, String x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateString");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Time value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateTime(int columnIndex, java.sql.Time x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateTime");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Time value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateTime(String columnName, java.sql.Time x) throws java.sql.SQLException {
    throwNotSupportedMethod("updateTime");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Timestamp value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnIndex the first column is 1, the second is 2, ...
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateTimestamp(int columnIndex, java.sql.Timestamp x)
  throws java.sql.SQLException {
    throwNotSupportedMethod("updateTimestamp");
}
/**
 * JDBC 2.0
 *
 * Updates a column with a Timestamp value.
 *
 * The <code>updateXXX</code> methods are used to update column values in the
 * current row, or the insert row.  The <code>updateXXX</code> methods do not
 * update the underlying database; instead the <code>updateRow</code> or <code>insertRow</code>
 * methods are called to update the database.
 *
 * @param columnName the name of the column
 * @param x the new column value
 * @exception java.sql.SQLException if a database access error occurs
 */
public void updateTimestamp(String columnName, java.sql.Timestamp x)
  throws java.sql.SQLException {
    throwNotSupportedMethod("updateTimestamp");
}
/**
 * wasNull method comment.
 */
public boolean wasNull() throws SQLException {
    return false;
}
  public URL getURL(int parm1) throws java.sql.SQLException{
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("getURL");
      return null;
  }
  public URL getURL(String parm1) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("getURL");
      return null;
  }
  public void updateRef(int parm1, Ref parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateRef");
      
  }
  public void updateRef(String parm1, Ref parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateRef");
  }
  public void updateBlob(int parm1, Blob parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateBlob");
  }
  public void updateBlob(String parm1, Blob parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateBlob");
  }
  public void updateClob(int parm1, Clob parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateClob");
  }
    public void updateClob(String parm1, Clob parm2) throws java.sql.SQLException {
        /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateClob");
    }
  public void updateArray(int parm1, Array parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateArray");
  }
  public void updateArray(String parm1, Array parm2) throws java.sql.SQLException {
    /**@todo: Implement this java.sql.ResultSet method*/
      throwNotImplementedMethod("updateArray");
      
  }

    /**
     * Helper for unimplemented method. Will throw an UnsupportedOperationException
     * with a localised message.
     * @param methodName name of unsupported method.
     * @exception java.lang.UnsupportedOperationException always
     */
    private void throwNotImplementedMethod(String methodName)
    {
        throw new UnsupportedOperationException
            (MessageTranslator.translate(MessageKey.ERROR_MEMORYRESULT_METHOD_NOTIMPLEMENTED,
                                         methodName));
    }

    /**
     * Helper for unsupported methods. Will throw an NotSupportedException 
     * with a localised message.
     * @param methodName name of the unsupported method (without '()')
     * @exception NotSupportedException always
     */
    private void throwNotSupportedMethod(String methodName)
        throws NotSupportedException
    {
        throw new NotSupportedException(MessageTranslator.translate(MessageKey.ERROR_MEMORYRESULT_METHOD_UNSUPPORTED,
                                                                    methodName),
                                        this);
    }
}
