/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;
import com.sap.dbtech.util.*;
import java.util.Calendar;
import com.sap.dbtech.jdbc.packet.*;

/**
 *
 */
public class TimeTranslator extends CharDataTranslator {
    /**
     * TimeTranslator constructor comment.
     * @param mode int
     * @param ioType int
     * @param len int
     * @param ioLen int
     * @param bufpos int
     */
    protected TimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos) {
        super(mode, ioType, dataType, len, ioLen, bufpos);
    }
    /**
     *
     * @return java.sql.Date
     */
    public Object getObject (
        SQLParamController controller,
        StructuredMem mem) throws SQLException
    {
        return this.getTime (controller, mem, null);
    }
        /**
     *
     * @return java.lang.String
     */
    public String getString (
            SQLParamController controller,
            StructuredMem mem) throws SQLException
    {
        String result = null;
        if (!this.isNull (controller, mem))
            result = mem.getString(this.bufpos, this.physicalLength - 1);
        return result;
    }
    /**
     *
     */
    protected int parseHours (
        byte [] raw)
    {
        return ((int)raw[0]-'0')*10 + ((int)raw[1]-'0');
    }
    /**
     *
     */
    protected int parseMinutes (
        byte [] raw)
    {
        return ((int)raw[3]-'0')*10 + ((int)raw[4]-'0');
    }
    /**
     *
     */
    protected int parseSeconds (
        byte [] raw)
    {
        return ((int)raw[6]-'0')*10 + ((int)raw[7]-'0');
    }
    /**
     *
     * @return java.sql.Date
     */
    public Time getTime (
        SQLParamController controller,
        StructuredMem mem,
        Calendar cal)
    throws SQLException
    {
        byte[] raw;
        Time result = null;

        if (!this.isNull (controller, mem)) {
            raw = mem.getBytes(this.bufpos, this.physicalLength - 1);

            int hour = this.parseHours (raw);

            int min = this.parseMinutes (raw);

            int sec = this.parseSeconds (raw);

            if (cal == null){
              result = new Time(hour,min,sec);
            } else {
              cal.clear() ;
              cal.set(1970,0,1,hour,min,sec);
              result = CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        return result;
    }
    /**
     *
     * @return java.sql.Date
     */
    public Timestamp getTimestamp (
        SQLParamController controller,
        StructuredMem mem,
        Calendar cal)
    throws SQLException
    {
        String raw;
        Time timeValue = this.getTime (controller, mem, cal);
        Timestamp result;

        if (timeValue == null) {
            return null;
        }
        return new Timestamp (timeValue.getTime ());
    }
    /**
     *
     * @return boolean
     */
    public boolean isCaseSensitive () {
        return false;
    }
    /**
     *
     * @param obj java.lang.Object
     */
    public Object transSpecificForInput (Object obj)
    throws SQLException
    {
        Object result = null;

        if (obj instanceof Time) {
            result = this.transTimeForInput ((Time) obj, java.util.Calendar.getInstance());
        }
        return result;
    }
    /**
     *
     * @param val java.lang.String
     */
    public Object transStringForInput (String val)
    throws SQLException
    {
        if (val == null) {
            return null;
        }
        try {
            return this.transTimeForInput (Time.valueOf (val),java.util.Calendar.getInstance());
        }
        catch (IllegalArgumentException exc) {
            // ignore, try timestamp
        }
        try {
            Timestamp ts = Timestamp.valueOf (val);
            return this.transTimeForInput (new Time (ts.getTime ()), java.util.Calendar.getInstance());
        }
        catch (IllegalArgumentException exc) {
            // possibly: try other parsing strategies
        }
        throw this.newParseException (val, "Time");
    }
    /**
     *
     * @param newValue java.sql.Time
     */
    public Object transTimeForInput (Time arg, Calendar cal)
    throws java.sql.SQLException
    {
        if (arg == null)
            return null;

        cal.setTime(arg);
        byte[] formattedTime = new byte[TimeSize_C];

        int hours = cal.get(Calendar.HOUR_OF_DAY);
        int minutes = cal.get(Calendar.MINUTE);
        int seconds = cal.get(Calendar.SECOND);
        return this.formatTime (hours, minutes, seconds);
    }
    final private static int TimeSize_C = 8;

    /**
     *
     */
    protected byte [] formatTime (
        int hours,
        int minutes,
        int seconds)
    {
        byte[] formattedTime = new byte[TimeSize_C];

        formattedTime[0] = HighTime_C[hours];
        formattedTime[1] = LowTime_C [hours];
        formattedTime[2] = (byte) ':';

        formattedTime[3] = (byte)('0'+(minutes/10));
        formattedTime[4] = (byte)('0'+(minutes%10));
        formattedTime[5] = (byte) ':';

        formattedTime[6] = (byte)('0'+(seconds/10));
        formattedTime[7] = (byte)('0'+(seconds%10));

        return formattedTime;
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     * @param data java.lang.Object
     */
    protected void putSpecific (
        DataPart dataPart,
        Object data)
    throws SQLException
    {
        byte [] bytes = (byte[])data;
        if (bytes.length > this.physicalLength - 1) {
            throw new com.sap.dbtech.jdbc.exceptions.ValueOverflow (
                com.sap.dbtech.vsp00.DataType.stringValuesC [this.dataType],
                -1);
        }
        dataPart.putInt1 ((byte) ' ', this.bufpos - 1);
        dataPart.putStringBytes (bytes, this.bufpos, this.physicalLength - 1);
    }}
