/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

public class UnicodeProcedurePutval extends AbstractProcedurePutval
{
	private Reader  reader;
    private boolean atBegin;
    private boolean marksupported;
    private int     length;
    
    public UnicodeProcedurePutval(DBTechTranslator translator, char[] buffer)
    {
        this(translator, new CharArrayReader(buffer), -1);
    }

    public UnicodeProcedurePutval(DBTechTranslator translator, Reader reader, int length)
    {
        super(translator);
        if(length <= 0) {
        	this.reader = reader;
        	this.length = Integer.MAX_VALUE; 
        } else {
        	this.reader = new ReaderFilter(reader, length);
        	this.length = length;
        }
        this.atBegin = true;
        this.marksupported = this.reader.markSupported();
    }

    public void transferStream(DataPart dataPart, short rowCount) throws SQLException
    {
        if(rowCount == STREAM_RESET) {
            if(!atBegin) {
                if(marksupported) {
                    try {
                        reader.reset();
                        reader.mark(length);
                    } catch(IOException ioEx) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
        						ioEx.getMessage()));
                    }
                } else {
                    throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_RESET_STREAM));
                }
            }
            rowCount = Short.MAX_VALUE;
        } else if(atBegin) {
            if(marksupported) {
            	try {
            		reader.mark(length);
            	} catch(IOException ioex) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
    						ioex.getMessage()));                   
            	}
            }
        }
        
        if(dataPart.fillWithProcedureReader(reader, rowCount)) {
            try {
                reader.close();
            } catch(IOException ioex) {
                throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
    						ioex.getMessage()));                   
            }
    	}          	
    }  

}
