/*!**************************************************************************

  module      : Log_HistoryFile.hpp
  special area: Logging
  responsible : UweH
  created     : 2000-09-25  12:00
  last changed: 2000-10-27  12:00
  copyright:    (c) 2000-2004 SAP AG
  description : defines the classes Log_HistoryFile



    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/


#ifndef Log_HistoryFile_H
#define Log_HistoryFile_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg91.h"
#include "SAPDBCommon/SAPDB_Types.hpp"
#include "DataAccess/Data_ChainFixSizeSpace.hpp"
#include "DataAccess/Data_BaseFile.hpp"
#include "Logging/Log_Types.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

class Log_UndoFile;
class Data_PageAccessManager;
class SAPDBMem_IRawAllocator;

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/
/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/
/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*---------------------------------------------------------------------------*/
/*! class:       Log_HistoryFile
    description: This stores anchors to undo file.
*/
class Log_HistoryFile : public Data_BaseFile
{

public:
    
    /*! --------------------------------------------------------------------------------
    declaration: Container, Iterator, BeforeImageId
    description: These types are used with this class.
    */
    typedef Data_PageFixSizeSpace             PageType;
    typedef Data_ChainFixSizeSpace<PageType>  Container;
    typedef Data_ChainIterator<PageType>      PageIterator;

    /*! --------------------------------------------------------------------------------
    declaration: UndoFileInfo
    description: This describes.
    */
    struct UndoFileInfo
    {
        Data_PageNo   root;       // 4
        Data_PageNo   last;       // 4
        tgg91_TransNo transno;    // 6
        SAPDB_UInt2   pagecount;  // 2
        UndoFileInfo()
        {
            root.Invalidate();
            last.Invalidate();
            transno.gg90SetNil();
            pagecount = 0;
        }
    };

    /*! --------------------------------------------------------------------------------
    declaration: Iterator
    description: points to UndoFileInfo's
    */
    class Iterator
    {
    public:
        Iterator (Container::Iterator& iter)
        : m_Iterator (iter)
        {}
        
        UndoFileInfo& operator * ()
        {
            return *(reinterpret_cast<UndoFileInfo*>(*m_Iterator));
        }

        Iterator& operator ++ ()
        {
            ++m_Iterator;
            return *this;
        }
        
        void Break()
        {
            m_Iterator.Break();
        }

        bool Continue()
        {
            return m_Iterator.Continue();
        }

        bool IsValid() const
        {
            return m_Iterator.IsValid();
        }
        
        void Invalidate()
        {
            m_Iterator.Invalidate();
        }
        
        Container::Iterator & GetContainerIter()
        {
            return m_Iterator;
        }
        
        void WriteToTrace(const char * title) const
        {
            m_Iterator.WriteToTrace(title);
        }
        
    private:
        Container::Iterator &m_Iterator;
    };
    
public:

    /*! --------------------------------------------------------------------------------
    function:    Log_HistoryFile
    arguments:   Trans               [in/out]
                 root          [in]
                 last          [in]
    description: If the root is valid, an existing file is assumed.
    */
    Log_HistoryFile ( tgg00_TransContext &Trans,
                      const Data_PageNo   Root,
                      const Data_PageNo   Last);
              
    /*! --------------------------------------------------------------------------------
    function:    Log_HistoryFile
    arguments:   Pam           [in/out]
                 root          [in]
                 last          [in]
    description: If the root is valid, an existing file is assumed.
    */
    Log_HistoryFile (Data_PageAccessManager &Pam,
                     SAPDBMem_IRawAllocator &Allocator,
                     const Data_PageNo       Root,
                     const Data_PageNo       Last);
              
    /*! ---------------------------------------------------------------------------
    function:    Create
    returns:     true, if successfull
    */
    virtual bool Create ();

    /*! ---------------------------------------------------------------------------
    function:    Drop
    */
    virtual void Drop ();

    /*! ---------------------------------------------------------------------------
    function:    Verify
    returns:     true, if the file is consistent
    */
    virtual bool Verify (bool isCold);

    /*! ---------------------------------------------------------------------------
    function:    LastPageNo
    returns:     pageno of last page
    */
    Data_PageNo& LastPageNo()
    {
        return m_Container.LastPageNo();
    }

    /*! --------------------------------------------------------------------------------
    function:    AppendUndoFile
    arguments:   file [in]
    description: A new entry is created and appended to the file.
    */
    void AppendUndoFile (Log_UndoFile &file);

    /*! --------------------------------------------------------------------------------
    function:    GetFirstUndoFileInfo
    returns:     iter to first info, which my be invalid
    -----------------------------------------------------------------------------*/
    Iterator& GetFirstUndoFileInfo ();

    /*! --------------------------------------------------------------------------------
    function:    RemoveUndoFileInfo
    arguments:   iter [in]
    description: This removes the referenced entry
    -----------------------------------------------------------------------------*/
    void RemoveUndoFileInfo (Iterator& iter);

private:

    /*! --------------------------------------------------------------------------------
    variable:    m_Container
    description: The container for this file.
    */
    Container m_Container;

    /*! --------------------------------------------------------------------------------
    variable:    m_ContainerIterator
    description: The iterator for the container.
    */
    Container::Iterator  m_ContainerIterator;

    /*! --------------------------------------------------------------------------------
    variable:    m_Iterator
    */
    Iterator  m_Iterator;

    /*! --------------------------------------------------------------------------------
    variable:    m_Allocator
    */
    SAPDBMem_IRawAllocator &m_Allocator;
};
/*! endclass: Log_HistoryFile */


/*===========================================================================*
 *  DEFINITION OF INLINE METHODS                                              *
 *===========================================================================*/

/*===========================================================================*
 *  DEFINITION OF INLINE METHODS                                              *
 *===========================================================================*/
                                         
#endif  /* Log_HistoryFile_H */
