/*!
 * \file    OMS_DummyKernelCallback.cpp
 * \author  IvanS, MarkusSi, PeterG, ThomasA
 * \brief   Dummy kernel sink
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/



#ifndef OMS_DUMMYKERNELCALLBACK_HPP
#define OMS_DUMMYKERNELCALLBACK_HPP

#include "liveCache/LVC_IliveCacheSink.hpp"
#include "ggg01.h"
//#include "ggg00.h"

/*! 
  Class: OMS_DummyKernelCallback

  Description: this class yields a dummy implementation of the kernel sink.
               All interface functions simply return ok.
*/

class OMS_DummyKernelCallback : public IliveCacheSink 
{
    virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
    /* [in] */ REFIID riid,
    /* [iid_is][out] */ void  **ppvObject) { return S_OK; }
    virtual ULONG STDMETHODCALLTYPE AddRef( void) { return S_OK; }
    virtual ULONG STDMETHODCALLTYPE Release( void) { return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE ABAPRead( 
    OmsTypeInt4   &tabHandle,
    OmsTypeInt4   &count,
    OmsTypeInt4   &bufSize,
    OmsTypeByte  *&buf,
    short         &error){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE ABAPWrite( 
    OmsTypeInt4    *TabHandle,
    tsp00_Int4      row_size,
    tsp00_Int4      row_count,
    unsigned char  *lpv,
    short          *lpb_error){ return S_OK; }
    
  virtual HRESULT STDMETHODCALLTYPE AllocPacket( 
    unsigned char  **p,
    tsp00_Int4      *sz){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE CloseVersion( 
    short        *lpb_error){ return S_OK; }
    
  virtual HRESULT STDMETHODCALLTYPE ConsoleMsg( 
    tsp00_Int4      buflen,
    unsigned char  *lpv){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE CreateVersion( 
    unsigned char  *lpConsistentView,
    unsigned char  *lpVersionContext,
    short          *lpb_error){ return S_OK; }

   virtual HRESULT STDMETHODCALLTYPE CreateKeyRangeIterator(
    tgg91_TransNo            &consistentView,
    tgg00_FileId             &objFile,
    tgg01_OmsVersionContext  *lpVersionContext,
    void                    **pKeyRangeIterator,
    tsp00_Int4                bodySize,
    tsp00_Int4                keyLen,
    const void               *pStartKey,              
    const void               *pLowerKey,             
    const void               *pUpperKey,              
    tsp00_Int4               &noOfOid,
    OmsTypeOid               *pResultOId,  
    tgg91_PageRef            *pObjSeq,
    unsigned char            *pBody,
    tsp00_Int4               &LogReadAccesses,
    tgg00_BasisError         &e,
    OmsIterDirection          direction = OMS_ASCENDING){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE StartUnloadedVersionIter(
    tgg91_TransNo           &consistentView,
    tgg01_OmsVersionContext *lpVersionContext,
    tgg00_FileId            &objFile,
    tsp00_Int4              keyLen,
    void                    *pStartKey,            
    const void              *pLowerKey,
    const void              *pUpperKey,
    tsp00_Int4              ObjBodySize,           
    void                    *pObjBody,             
    OmsTypeOid              &ResultOId,            
    short                   &e,
    OmsIterDirection        direction){ return S_OK; }             
  
  virtual HRESULT STDMETHODCALLTYPE DeleteAllObj(
    tgg91_TransNo&  consistentView,
    unsigned char  *lpContainerId,
    unsigned char  *lpVersionFile,
    int            &lpDeleted,
    short          &lpb_error,
    OmsTypeOid     &errorOid){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE DeleteObj( 
    unsigned char  *lpConsistentView,
    unsigned char  *lpContainerId,
    unsigned char  *lpVersionContext,
    unsigned char  *lpoid,
    unsigned char  *lpobjseq,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE DeleteObjMass(
    tsp00_Int4               cnt,
    tgg91_TransNo           *pConsistentView,
    tgg01_ContainerId      **ppContainerId,
    unsigned char           *pVersionContext,
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjSeq,
    tsp00_Int4              &errCnt,
    tgg00_BasisError        *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE DestroyKeyRangeIterator(
    void* pKeyRangeIterator){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE EndConsistentView( 
    unsigned char  *lpConsistentView,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE EnterCriticalSection(
    short regionId){ return S_OK; }
 
  virtual HRESULT STDMETHODCALLTYPE GetContainerId(    
    tgg01_ContainerId              *pcontainerId, 
    const tgg01_OmsVersionContext  *pVersionContext,
    tsp00_Int4                      noOfOid,
    const OmsTypeOid               *pOid,
    tgg00_BasisError               *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetObj( 
    tgg91_TransNo                 &consistentView,
    tgg01_ContainerId             &containerId, 
    const tgg01_OmsVersionContext *pVersionContext,
    const OmsTypeOid              &oid,
    bool                           doLock,
    tgg91_PageRef                 &objSeq,
    tsp00_Int4                     bodySize,
    unsigned char                 *pBody,
    tsp00_Int4                    &bodyLen,
    tsp00_Int4                    &histLogCount,
    tgg00_BasisError              &e){ return S_OK; } 

  virtual HRESULT STDMETHODCALLTYPE GetObjects(
    tgg91_TransNo                 &consistentView,
    tgg01_ContainerId             *pContainerId, 
    const tgg01_OmsVersionContext *pVersionContext,
    tsp00_Int4                     noOfOid,
    const OmsTypeOid              *pOid,
    tgg91_PageRef                 *pObjVers,
    tsp00_Int4                    *pBodySize,
    bool                           doLock,
    unsigned char                **ppObj,
    tsp00_Int4                    &histLogCount,
    tsp00_Int4                    &errorCount,
    tgg00_BasisError              *e){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetObjWithKey( 
    unsigned char  *lpConsistentView,
    unsigned char  *lptree,
    unsigned char  *lpVersionContext,
    tsp00_Int4      keylen,
    unsigned char  *lpkey,
    boolean         doLock,
    tsp00_Int4      bodysize,
    unsigned char  *lpbody,
    OmsTypeOid     *lpoid,
    unsigned char  *lpobjseq,
    int            *hist_log_count,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetObjectsWithKey( 
    tgg91_TransNo            *pConsistentView,
    tgg01_ContainerId        *pContainerId,
    tgg01_OmsVersionContext  *pVersionContext,
    tsp00_Int4               *pKeyLen,
    tsp00_Int4                noOfObj,
    unsigned char           **ppKey,
    boolean                   doLock,
    tsp00_Int4               *pBodySize,
    unsigned char           **ppBody,
    OmsTypeOid               *pOid,
    tgg91_PageRef            *pObjSeq,
    tsp00_Int4               &histLogCnt,
    tsp00_Int4               &errorCnt,
    tgg00_BasisError         *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE HResultError( 
    HRESULT h_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE IsLocked( 
    unsigned char  *lpContainerId,
    OmsTypeOid     *lpoid,
     short         *lpb_error){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE LeaveCriticalSection(
    short regionId){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE LockObj( 
    unsigned char  *lpConsistentView,
    unsigned char  *lpContainerId,
    OmsTypeOid     *lpoid,
    unsigned char  *lpobjseq,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE LockObjMass(
    tsp00_Int4              &cnt,
    tgg91_TransNo           *pConsistentView,
    tgg01_ContainerId      **ppContainerId,
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjSeq,
    tsp00_Int8              &timeout,
    tsp00_Int4              &errCnt,
    tgg00_BasisError        *pDBError){ return S_OK; }
 
  virtual HRESULT STDMETHODCALLTYPE MultiPurpose( 
    unsigned char   MessType,
    unsigned char   MessType2,
    tsp00_Int4     *lpbuflen,
    unsigned char  *lpv,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE NewConsistentView( 
    unsigned char  *lpConsistentView,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE NewObj( 
    unsigned char  *lpConsistentView,
    unsigned char  *lpContainerId,
    unsigned char  *lpVersionContext,
    tsp00_Int4      KeyPos,
    tsp00_Int4      KeyColSize,
    unsigned char  *KeyColumn,
    OmsTypeOid     *lpoid,
    unsigned char  *lpobjseq,
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE NewObjMass( 
    tsp00_Int4               cnt,
    tgg91_TransNo           *pConsistentView,
    tgg01_ContainerId      **ppContainerId,
    unsigned char           *pVersionContext,
    tsp00_Int4              *pKeyPos,
    tsp00_Int4              *pKeyColSize,
    unsigned char          **ppKeyColumn, 
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjSeq,
    tsp00_Int4              &errCnt,
    tgg00_BasisError        *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE NextOids(
    tgg91_TransNo           &ConsistentView,
    tgg00_FileId            &ContainerId,
    tgg01_OmsVersionContext *pVersionContext,
    OmsTypeOid               CurrOid,
    tsp00_Int4              &noOfOid,
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjVers,
    tsp00_Int4              &LogReadAccesses,
    tgg00_BasisError        *pb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE NextObjFromKeyIterator (
    const tgg91_TransNo     &ConsistentView,  // PTS 1127520 
    tgg01_ContainerId       &ObjFile,
    tgg01_OmsVersionContext *VersionContext,
    void                    *pKeyIterator,
    tsp00_Int4               bodySize,
    tsp00_Int4               KeyLen,
    void                    *pRestartKey, 
    tsp00_Int4              &NoOfOId,
    OmsTypeOid              *pResultOId, 
    tgg91_PageRef           *pObjVers,
    unsigned char           *pBody,
    tsp00_Int4              &objHistReadCount,
    tgg00_BasisError        &e){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE VersionNextKey(
    tgg01_OmsVersionContext  *VersionContext,
    const tgg01_ContainerId  &ObjFile,
    void                     *pKey,
    tsp00_Int4                KeyLen,
    bool                      Inclusive,
    const void               *pStopKey,
    OmsTypeOid               &Oid,
    tgg00_BasisError         &e){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE PrevObjFromKeyIterator ( 
    const tgg91_TransNo     &ConsistentView,  // PTS 1127520 
    tgg01_ContainerId       &ObjFile,
    tgg01_OmsVersionContext *VersionContext,
    void                    *pKeyIterator,
    tsp00_Int4               bodySize,
    tsp00_Int4               KeyLen,
    void                    *pRestartKey, 
    tsp00_Int4              &NoOfOId,
    OmsTypeOid              *pResultOId, 
    tgg91_PageRef           *pObjVers,
    unsigned char           *pBody,
    tsp00_Int4              &objHistReadCount,
    tgg00_BasisError        &e){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE VersionPrevKey(   
    tgg01_OmsVersionContext  *VersionContext,
    const tgg01_ContainerId  &ObjFile,
    void                     *pKey,
    tsp00_Int4                KeyLen,
    bool                      Inclusive,
    const void               *pStopKey,
    OmsTypeOid               &Oid,
    tgg00_BasisError         &e){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE RegisterClass(
    tsp00_Int4           SchemaId,
    GUID                *lpGUID,
    tsp00_KnlIdentifier *lpClassName,
    tsp00_Int4           size,
    OmsContainerNo       ContainerNo,
    tsp00_Int4           keyPos,          // PTS 1122540
    tsp00_Int4           keyLen,          // PTS 1122540
    bool                 keyPartitioned,  // PTS 1122540
    unsigned char       *lpContainerId,
    short               *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE ResetVersion( 
    unsigned char *lpVersionContext,
    short          &error){ return S_OK; }
 
  virtual HRESULT STDMETHODCALLTYPE SetError( 
    short                 errorno,
    tsp00_Int4            buflen,
    const unsigned char  *lpv,
    tsp00_CodeType        codeType ){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE SQLRequest( 
    tsp00_Int4      buflen,
    unsigned char  *lpv){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE SubtransCommit( 
    short  *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE SubtransRollback( 
    short  *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE SubtransStart( 
    short  *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE UnlockObj( 
    unsigned char  *lpContainerId,
    OmsTypeOid     *lpoid,
    short          *lpb_error){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE UpdateObj( 
    unsigned char  *lpConsistentView,
    unsigned char  *lpContainerId,
    unsigned char  *lpVersionContext,
    unsigned char  *lpoid,
    unsigned char  *lpobjseq,
    tsp00_Int4      bodysize,
    unsigned char  *lpbody,
    tsp00_Int4      keyPos,            // PTS 1122540
    tsp00_Int4      keyLen,            // PTS 1122540
    bool            contObj,           // PTS 1124278
    short          *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE UpdateObjMass(
    tsp00_Int4               cnt,
    tgg91_TransNo           *pConsistentView,
    tgg01_ContainerId      **ppContainerId,
    unsigned char           *pVersionContext,
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjSeq,
    tsp00_Int4              *pBodySize,
    unsigned char          **ppBody,
    tsp00_Int4              *pKeyPos,       // PTS 1122540
    tsp00_Int4              *pKeyLen,       // PTS 1122540
    tsp00_Int4              &errCnt,
    tgg00_BasisError        *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE UpdateVarObjMass(
    tsp00_Int4               cnt,
    tgg91_TransNo           *pConsistentView,
    tgg01_ContainerId      **ppContainerId,
    unsigned char           *pVersionContext,
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjSeq,
    tsp00_Int4              *pObjSize,
    tsp00_Int4              *pBodySize,
    unsigned char          **ppBody,
    OmsTypeOid              *pNextOid,
    bool                    *pContObj,  // PTS 1124278
    tsp00_Int4              &errCnt,
    tgg00_BasisError        *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE Vtrace( 
    tsp00_Int4      buflen,
    unsigned char  *lpv){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetDefaultContext(
    void         **p, 
    pasbool      **pCancelByte,
    tsp00_TaskId  &taskId /* PTS 1110315 */){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE SetDefaultContext(
    void* p){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetSqlSessionContext(
    void** p){ return S_OK; }
        
 virtual HRESULT STDMETHODCALLTYPE SetSqlSessionContext(
   void* p){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE OpenFile(
    char        *lpFileName,
    tsp00_Uint4  FileSize,
    boolean      doAppend, 
    tsp00_Int4  *FileHandle,
    short       *lpb_error){ return S_OK; }
    
  virtual HRESULT STDMETHODCALLTYPE WriteFile(
    tsp00_Int4 FileHandle,
    char      *msg,
    short     *lpb_error){ return S_OK; } 

  virtual HRESULT STDMETHODCALLTYPE CloseFile(
    tsp00_Int4  FileHandle,
    short      *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE SyncFile(
    char       *lpFileName,
    tsp00_Int4  FileHandle,
    short      *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetDateTime(
    tsp00_Date* Date,
    tsp00_Time* Time){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE GetClock(
    tsp00_Int4* Sec,
    tsp00_Int4* MSec){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE DropVersion( 
    unsigned char  *lpVersionContext,
    short          *lpb_error){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE CreateSchema(
    const OmsTypeWyde *lpSchemaName,
    tsp00_Int4        *lpSchemaId,
    short             *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE ExistsSchema(
    const OmsTypeWyde *lpSchemaName,
    tsp00_Int4        *lpSchemaId,
    short             *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE DropSchema(
    tsp00_Int4  SchemaId,
    short      *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetSchemaName(
    tsp00_Int4    SchemaId,
    OmsTypeWyde  *lpSchemaName,
    short        *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE ExistsFile(
    char    *lpFileName,
    bool    &existsFile,
    bool    &isDirectory,
    short   &error){ return S_OK; }
  
  virtual HRESULT STDMETHODCALLTYPE DropFile(
    char  *lpFileName,
    short &error){ return S_OK; } 

  virtual HRESULT STDMETHODCALLTYPE GetWorkingDirectory(
    tsp00_Pathc &pathName,
    short       &error){ return S_OK; } 

  virtual HRESULT STDMETHODCALLTYPE GetDbrootSapPath(
    tsp00_Pathc &pathName,
    short       &error){ return S_OK; }
    
  virtual HRESULT STDMETHODCALLTYPE LoadLibraryEx( 
    const char    *path, 
    bool           loadGlobal,
    HANDLE        *hd,
    tsp00_ErrText &errtext,
    int            errtext_size){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE FreeLibrary( 
    HANDLE         hd,
    bool          &ok,
    tsp00_ErrText &errtext,
    int            errtext_size){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE DropContainer(
    OmsSchemaHandle  schema,
    const GUID       &guid,
    OmsContainerNo    cno,
    tgg00_BasisError &error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE GetContainerInfo(
    tsp00_Uint4      containerHandle,
    GUID            &guid,
    OmsSchemaHandle &schema,
    OmsContainerNo  &cno,
    short           &error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE IsObjHistoryUsed( 
    const OmsTypeOid  &oid,
    bool              &isUsed,
    tgg00_BasisError  &e){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE Reschedule(){ return S_OK; } /* PTS 1107849 */
  
  virtual HRESULT STDMETHODCALLTYPE LockUpdObj( 
    unsigned char   *lpConsistentView,
    unsigned char   *lpContainerId,
    OmsTypeOid      *lpoid,
    unsigned char   *lpobjseq,
    short           *lpb_error){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE LockUpdObjMass(
    tsp00_Int4               cnt,
    tgg91_TransNo           *pConsistentView,
    tgg01_ContainerId      **ppContainerId,
    OmsTypeOid              *pOid,
    tgg91_PageRef           *pObjSeq,
    tsp00_Int4              &errCnt,
    tgg00_BasisError        *pDBError){ return S_OK; }

  virtual HRESULT STDMETHODCALLTYPE Signal(
    tsp00_TaskId TaskId, 
    tsp00_Bool   ok){ return S_OK; } // PTS 1110315

  virtual HRESULT STDMETHODCALLTYPE Wait(
    tsp00_Bool& ok){ return S_OK; } // PTS 1110315

  virtual HRESULT STDMETHODCALLTYPE ExistsContainer(
    tsp00_Int4       SchemaId,
    const GUID      &Guid,
    OmsContainerNo   ContainerNo,
    short           &error){ return S_OK; } // PTS 1110334

  virtual HRESULT STDMETHODCALLTYPE GetSessionHeapUsage(
    tsp00_8ByteCounter& heapUsage){ return S_OK; } 

  virtual HRESULT STDMETHODCALLTYPE EvalCallStatistics(
     bool            AllocatorOnly,
     OmsMonitorData &MonitorData){ return S_OK; } 

	virtual HRESULT STDMETHODCALLTYPE SimCtlDumpToHtml(
			class OmsHandle				&handle,
			const struct OmsObjectId	&obj, 
			class OmsSimDumpCollector	&str)
	{ return S_OK; } 

	virtual HRESULT STDMETHODCALLTYPE SimCtlSetObjectName(
			class OmsHandle				&handle,
			const struct OmsObjectId	&obj,
			const char					*name)
	{ return S_OK; }

	virtual HRESULT STDMETHODCALLTYPE SimCtlDestroyHandleCB(
			class OmsHandle				&handle,
			struct IliveCacheSink		**session)
	{
		return S_OK;
	}

    virtual HRESULT STDMETHODCALLTYPE GetSessionAllocator(SAPDBMem_IRawAllocator* &allocator) 
    {
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE GetOmsSessionAllocator(SAPDBMem_IRawAllocator* &allocator)
    {
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE SimCtlGetHTMLRef(
			class OmsHandle				&handle,
			const struct OmsObjectId	&obj,
			const char					**data,
			int							flags)
    {
        *data = "";
        return S_OK;
    }


   virtual HRESULT STDMETHODCALLTYPE SimCtlGetObjectName(
			class OmsHandle				&handle,
			const struct OmsObjectId	&obj,
			const char					**name)
	{
		*name = NULL;
		return S_OK;
	}


    virtual HRESULT STDMETHODCALLTYPE IsInRegion(
       int   regionId,
       bool& inRegion)
    {
        inRegion = false;
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE GetSqlClsAllocator(SAPDBMem_IRawAllocator* &allocator) 
    { return S_OK; }

    virtual HRESULT STDMETHODCALLTYPE AttachSequence(const tsp00_KnlIdentifier& sequenceName,
                                                     tgg00_Surrogate&           sequenceId,
                                                     tgg00_SeqInfo&             sequenceInfo,
                                                     short&                     error)
    { return S_OK; }
 
    virtual HRESULT STDMETHODCALLTYPE NextVal(const tgg00_Surrogate& sequenceId,
                                              tgg00_SeqInfo&         sequenceInfo,
                                              tsp00_Uint4&           nextVal,
                                              short&                 sqlError)
    {
        nextVal = 0;
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE GetGlobalUserAllocator(
        OmsAllocatorInterface* &allocator, const char *name)
    {
        allocator = NULL;
        return S_OK;
    } 

    virtual HRESULT STDMETHODCALLTYPE GetSessionUserAllocator(
        OmsAllocatorInterface* &allocator)
    {
        allocator = NULL;
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE GetTransactionUserAllocator(
        OmsAllocatorInterface* &allocator)
    {
        allocator = NULL;
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE GetCOMRoutineUserAllocator(
        OmsAllocatorInterface* &allocator)
    {
        allocator = NULL;
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE UserAllocatorCtl(
        int msg, void *param)
    { return S_OK; }

    virtual HRESULT STDMETHODCALLTYPE IsUnicodeInstance(
         bool& isUnicodeInstance, short& sqlError)
    {
        isUnicodeInstance = false;
        sqlError          = 0;
        return S_OK; 
    }

    virtual int STDMETHODCALLTYPE GetSinkType()
    {
      return 0;
    }
};

/*! endclass: OMS_DummyKernelCallback */


#endif
