#ifndef __OMS_IGUIDHASH_HPP
#define __OMS_IGUIDHASH_HPP

#include "Oms/OMS_Defines.h"
#include "gsp00.h"
#include "livecachetypes.h" // nocheck

class OMS_IGuidHash {
public:
  static tsp00_Int4 HashValue(const ClassIDRef guid, tsp00_Int4 maxSlot) {
#ifdef	LIVECACHE_INTGUIDS
    return ((tsp00_Uint4) omsMaskGuid(guid)) % ((tsp00_Uint4) maxSlot);
#else
    return guid.Data1 % maxSlot;
#endif
  }
  static tsp00_Int4 HashValue(const ClassIDRef guid, OmsSchemaHandle s, OmsContainerNo c, tsp00_Int4 maxSlot) {
#ifdef	LIVECACHE_INTGUIDS
    return ((tsp00_Uint4) (omsMaskGuid(guid) ^ (s * 48623) ^ (c * 7))) % ((tsp00_Uint4) maxSlot);
#else
    return (guid.Data1 ^ (s * 48623) ^ (c * 7)) % maxSlot;
#endif
  }
};

#endif  // __OMS_IGUIDHASH_HPP
