#ifndef __OMS_SHAREDMEMALLOCATOR_HPP
#define __OMS_SHAREDMEMALLOCATOR_HPP

#include "gsp00.h"

class OMS_SharedMemAllocator {
public :
  OMS_SharedMemAllocator();
  inline void  *allocate(size_t sz);
  inline void  deallocate(void* pz);

  static void *allocateImpl(size_t sz);
  static void deallocateImpl(void *p);
private :
  tsp00_8ByteCounter m_sharedMemUsed;
};

/*----------------------------------------------------------------------*/

inline void* OMS_SharedMemAllocator::allocate(size_t sz) {
  return allocateImpl(sz);
}

/*----------------------------------------------------------------------*/

inline void OMS_SharedMemAllocator::deallocate(void *p) {
  deallocateImpl(p);
}

#endif //__OMS_SHAREDMEMALLOCATOR_HPP
