/*!******************************************************************************

  @file         hbd20_1.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        BD-data-cache

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD20_1_H
#define HBD20_1_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xd2\xe7\xf3\xfd\xeb\x7b\xb0\xd1\x2d\x1b\x2a\xaa\xe6\x0b\xac\x3c'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void bd20GetCacheSize (
    tsp00_Int4            &  TotalPages,
    tsp00_Int4            &  UnMapPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20GetWorkloadCounter (
    tsp00_Int4            &  DataCacheSize,
    tsp00_Int4            &  OmsHistoryPageCnt,
    tsp00_Int4            &  OmsDataPageCnt,
    tsp00_Int4            &  OmsUnloadedVersPageCnt,
    tsp00_Int4            &  SqlDataPageCnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

