/*!
  @file           ven68.c
  @author         JoergM
  @special area   Kernel RunTime
  @brief          Console Functions for Kernel
  @see            


    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#define MOD__ "ven68.c:"

#include "gen00.h"
#include "heo00.h"
#include "gen50.h"
#include "gen500.h"
#include "gen45.h"

/* imported functions */

#include "hen50.h" /* vabort */
#include "heo68.h"

/*
 * =================================================================
 */

void    xcancel ( 
tsp00_TaskId pid )
{
  struct  TASK_TYPE               * tcb ;

  DBG1 (( MF__,"xcancel: called \n" ));
  tcb = kgs->pFirstTaskCtrl + pid - 1 ;

  tcb->rte_comm.to_cancel = 1 ;

  DBG1 (( MF__,"xcancel: returning \n" ));
}

/*
 * =================================================================
 */

void    xkill ( 
tsp00_TaskId pid )
{
  struct  TASK_TYPE               * tcb ;

  DBG1 (( MF__,"xkill: called \n" ));
  tcb = kgs->pFirstTaskCtrl + pid - 1 ;

  sql45_kill_task ( tcb );

  DBG1 (( MF__,"xkill: returning \n" ));
}

/*
 * =================================================================
 */

void    xio ( 
tsp2_devname                    devspace ,
tsp00_Int4                      * size ,
tsp00_Int4                      * readcount ,
tsp00_Int4                      * writecount )
{
DBG1 (( MF__,"xio: called \n" ));
DBG1 (( MF__,"xio: returning \n" ));
}

/*
 * =================================================================
 */

void    xstorage ( 
tsp00_Int4                      * codesize ,
tsp00_Int4                      * datasize ,
tsp00_Int4                      * stacksize ,
tsp00_Int4                      * taskcount ,
tsp00_Int4                      * unused )
{
DBG1 (( MF__,"xstorage: called \n" ));
DBG1 (( MF__,"xstorage: returning \n" ));
}

/*
 * =================================================================
 */

void    xprocess ( 
tsp00_TaskId                      pid ,
tsp00_TaskId                    * uid ,
tsp2_process_type_Param         * ptype ,
tsp00_TaskState_Param           * pstate ,
tsp00_Region                      semaname ,
tsp00_Int4                      * timeout ,
tsp00_Int4                      * commandcount ,
tsp00_Int4                      * file_root ,
tsp00_Int4                      * file_record_cnt )
{
DBG1 (( MF__,"xprocess: called \n" ));
DBG1 (( MF__,"xprocess: returning \n" ));
}

/*
 * =================================================================
 */

void    xversion ( 
tsp00_Version kernelversion ,
tsp00_Version runtimeversion )
{
DBG1 (( MF__,"xversion: called \n" ));
DBG1 (( MF__,"xversion: returning \n" ));
}

/*
 * =================================================================
 */

void    xregions ( 
tsp00_RegionId    sid ,
tsp00_Region      semaname ,
tsp00_Int4                      * semcalls ,
tsp00_Int4                      * collisions )
{
DBG1 (( MF__,"xregions: called \n" ));
DBG1 (( MF__,"xregions: returning \n" ));
}

/*
 * =================================================================
 */

void    xstate ( 
tsp00_DatabaseState_Param * dbstate )
{
DBG1 (( MF__,"xstate: called \n" ));
DBG1 (( MF__,"xstate: returning \n" ));
}
