/*



    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
#if defined(_WIN32)
  #line 3 "d:\\v72\\sys\\src\\in\\hin110.h"
#endif 

/*! 
  -----------------------------------------------------------------------------
 
  module: hin110.h
 
  -----------------------------------------------------------------------------
 
  responsible:  BerndV
 
  special area: Primitive SQL Interface
 
  description:  Specification of SQL access classes

                This modul contains two classes (tin110_SQLResultTable and
                tin110_SQLRecord) to access database tables via SQL.

                The SQLResultTable object represents the result of
                a SELECT statement. Via the member functions record and
                nextRecord you can step trough all records of the result.
                (Only forward navigation is possible.) These functions are 
                returning SQlRecord objects. In a SQLRecord object you have 
                free access to all fields of a record via the number or the 
                name of a field.

                <B>
                Sorry, but this interface is not designed (and optimized)
                to process a big amount of data and records. Also the
                access to the data is not very flexible.
                </B>

                If you have some special needings (e.g. other datatypes
                for field values) so feel free to ask me (Bernd Vorsprach)
                or write new functions by yourself.
                
  version:      min 7.2.

  -----------------------------------------------------------------------------
 
                          Copyright (c) 1998-2004 SAP AG
 
  -----------------------------------------------------------------------------
*/
 

#ifndef _HIN110_H_
#define _HIN110_H_

/* 
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
*/
#include "gsp00.h"
#include "geo200.h"
#include "hin29.h"

/*!
  -----------------------------------------------------------------------------
  Class:        tin110_SQLRecord
  -----------------------------------------------------------------------------

  description:  SQL Record Object

  -----------------------------------------------------------------------------
 */
class tin110_SQLRecord {

  public:

    /*!  
      Chapter: Construction, Destruction and Assignment
     */

    /*!
      -------------------------------------------------------------------------
      function:     tin110_SQLRecord
      -------------------------------------------------------------------------
      description:  Constructor

      arguments:    pSession [IN]  - Pointer to SQL session
                    aRecord  [IN]  - an other record object

      prototypes: 3
      -------------------------------------------------------------------------
     */
    tin110_SQLRecord  ( );
    tin110_SQLRecord  ( tin01_sql_session * pSession );
    tin110_SQLRecord  ( const tin110_SQLRecord  & aRecord  );

    /*!
      -------------------------------------------------------------------------
      function:     ~tin110_SQLRecord
      -------------------------------------------------------------------------
      description:  Destructor

      -------------------------------------------------------------------------
     */
    ~tin110_SQLRecord  ( );

   /*!
      -------------------------------------------------------------------------
      function:     operator =
      -------------------------------------------------------------------------
      description:  Assignment

      arguments:    aRecord  [IN]  - an aother record object

      -------------------------------------------------------------------------
     */
    tin110_SQLRecord & operator = (const tin110_SQLRecord & aRecord);

    /*!  
      EndChapter: Construction, Destruction and Assignment
     */

    /*!  
      Chapter: Data retrieving
     */

    /*!
      -------------------------------------------------------------------------
      function:     fieldAsInt
      -------------------------------------------------------------------------
      description:  returns a field contents

                    If there no valid conversion from DB datatype to tsp00_Int4
                    or any other error occured a value of 0 will be returned.
                    Check also isNull() and fieldType() if you won't trust this 
                    behavior.

      arguments:    nField  [IN] - number of field
                    szField [IN] - name of field

      return value: field value

      prototypes:   2

      -------------------------------------------------------------------------
     */
     tsp00_Int4  fieldAsInt ( const tsp00_Int4 nField  );
     tsp00_Int4  fieldAsInt ( const _TCHAR *   szField );

    /*!
      -------------------------------------------------------------------------
      function:     fieldAsUInt
      -------------------------------------------------------------------------
      description:  returns a field contents

                    If there no valid conversion from DB datatype to tsp00_Uint4
                    or any other error occured a value of 0 will be returned.
                    Check also isNull() and fieldType() if you won't trust this 
                    behavior.

      arguments:    nField  [IN] - number of field
                    szField [IN] - name of field

      return value: field value

      prototypes:   2

      -------------------------------------------------------------------------
     */
     tsp00_Uint4  fieldAsUint ( const tsp00_Int4 nField  );
     tsp00_Uint4  fieldAsUint ( const _TCHAR *   szField );

    /*!
      -------------------------------------------------------------------------
      function:     fieldAsChar
      -------------------------------------------------------------------------
      description:  returns a field contents

                    If there no valid conversion from DB datatype to _TCHAR *
                    or any other error occured a empty String will be returned.
                    Check also isNull() and fieldType() if you won't trust this 
                    behavior.

      arguments:    nField       [IN] - number of field
                    szField      [IN] - name of field
                    cStringQuote [in] - character for quoting strings
                                        0 means no quoting
      return value: field value

                    This is a temporarely allocated buffer. It will only valid
                    until the next call of fieldAsChar or until the destruction 
                    of the object.

      prototypes:   2

      -------------------------------------------------------------------------
     */
     const _TCHAR * fieldAsChar ( const tsp00_Int4 nField,
                                  const _TCHAR     cStringQuote = 0);
     const _TCHAR * fieldAsChar ( const _TCHAR *   szField,
                                  const _TCHAR     cStringQuote = 0);

    /*!
      -------------------------------------------------------------------------
      function:     fieldType
      -------------------------------------------------------------------------
      description:  returns a field type

      arguments:    nField       [IN] - number of field
                    szField      [IN] - name of field

      return value: field type

      prototypes:   2

      -------------------------------------------------------------------------
     */
     tsp00_DataType fieldType ( const tsp00_Int4 nField  );
     tsp00_DataType fieldType ( const _TCHAR *   szField );

    /*!
      -------------------------------------------------------------------------
      function:     isNull
      -------------------------------------------------------------------------
      description:  returns a the nullvalue flag

      arguments:    nField       [IN] - number of field
                    szField      [IN] - name of field

      return value: true if null, otherwise false

      prototypes:   2

      -------------------------------------------------------------------------
     */
     bool isNull ( const tsp00_Int4 nField  );
     bool isNull ( const _TCHAR *   szField );

    /*!
      -------------------------------------------------------------------------
      function:     exists
      -------------------------------------------------------------------------
      description:  check the existence of a field

      arguments:    nField       [IN] - number of field
                    szField      [IN] - name of field

      return value: true if exist, otherwise false

      prototypes:   2

      -------------------------------------------------------------------------
     */
     bool exists ( const tsp00_Int4 nField  );
     bool exists ( const _TCHAR *   szField );

    /*!
      -------------------------------------------------------------------------
      function:     fieldName
      -------------------------------------------------------------------------
      description:  returns a field name

      arguments:    nField  [IN] - number of field, enumeration of fileds is 
                                   starting with 1

      return value: field name

                    This is a temporarely allocated buffer. It will only valid
                    until the next call of fieldName or until the destruction 
                    of the object.


      -------------------------------------------------------------------------
     */
     const _TCHAR * fieldName ( const tsp00_Int4 nField  );

    /*!
      -------------------------------------------------------------------------
      function:     fieldNumber
      -------------------------------------------------------------------------
      description:  returns a field number

      arguments:    szField  [IN] - name of field

      return value: field number

      -------------------------------------------------------------------------
     */
     tsp00_Int4 fieldNumber ( const _TCHAR * szField  );

    /*!
      -------------------------------------------------------------------------
      function:     fields
      -------------------------------------------------------------------------
      description:  returns the number of fields

      return value: number of fields

      -------------------------------------------------------------------------
     */
     tsp00_Int4 fields ( );

    /*!  
      EndChapter: Data retrieving
     */

  protected:

     _TCHAR * newField    ( const tsp00_Int4 nSize );
     _TCHAR * deleteField ( );
     _TCHAR * newString   ( const tsp00_Int4 nSize );
     _TCHAR * deleteString( );

     tin01_sql_session * m_pSession;
     _TCHAR            * m_pField;
     _TCHAR            * m_pString;
};

/*! EndClass: tin110_SQLRecord */

/*!
  -----------------------------------------------------------------------------
  Class:        tin110_SQLResultTable
  -----------------------------------------------------------------------------

  description:  SQL Result table Object

  -----------------------------------------------------------------------------
 */
class tin110_SQLResultTable {

  public:

    /*!  
      Chapter: Construction and destruction
     */

    /*!
      -------------------------------------------------------------------------
      function:     tin110_SQLResultTable
      -------------------------------------------------------------------------
      description:  Constructor

                    This constructor will execute the provided statement
                    at the database.

                    Check sqlRc() or lastEvent() for errors.


      arguments:    pSQLSession  [IN] - user session to db kernel
                    szSelectStmt [IN] - statement to execute

      prototypes:   2

      -------------------------------------------------------------------------
     */
    tin110_SQLResultTable  (  tin01_sql_session * pSQLSession,
                              const _TCHAR      * szSelectStmt);
    tin110_SQLResultTable  (  tin01_sql_session * pSQLSession);

    /*!  
      EndChapter: Construction and destruction
     */

    /*!  
      Chapter: Error handling
     */

    /*!
      -------------------------------------------------------------------------
      function:     lastEvent
      -------------------------------------------------------------------------
      description:  get last error description

                    For more in informatio see <a href="http://pwww/LZU/specs/event-list-handling.html">Event List Handling</a>.

      return value: A Object of teo200_EventList. This object might contains
                    more then one entry.

      -------------------------------------------------------------------------
     */
    teo200_EventList & lastEvent ( );


    /*!
      -------------------------------------------------------------------------
      function:     sqlRc
      -------------------------------------------------------------------------
      description:  SQL error state

      return value: last SQL returnd code

      -------------------------------------------------------------------------
     */
    int sqlRc                    ( );

    /*!  
      EndChapter: Error handling
     */

    /*!  
      Chapter: Data retrieving
     */

    /*!
      -------------------------------------------------------------------------
      function:     execute
      -------------------------------------------------------------------------
      description:  executes a statement

                    Check sqlRc() or lastEvent() for errors after
                    executing statement.

                    All record objects will be invalid after this call.

      return value: a record object

      -------------------------------------------------------------------------
     */
     void   execute     ( const _TCHAR      * szSelectStmt );

    /*!
      -------------------------------------------------------------------------
      function:     record
      -------------------------------------------------------------------------
      description:  returns current record

                    Check sqlRc() or lastEvent() for errors before using
                    record().

      return value: a record object

      -------------------------------------------------------------------------
     */
     tin110_SQLRecord record     ( );

    /*!
      -------------------------------------------------------------------------
      function:     nextRecord
      -------------------------------------------------------------------------
      description:  fetches and returns the next record

                    Check sqlRc() or lastEvent() for errors.

      return value: a record object

      -------------------------------------------------------------------------
     */
     tin110_SQLRecord nextRecord ( );

    /*!  
      EndChapter: Data retrieving
     */

  protected:

    teo200_EventList    m_EvtLast;  
    tin01_sql_session * m_pSession;
    int                 m_nSqlRc;
};

/*! EndClass: tin110_SQLResultTable */

#endif  // _HIN110_H_
