/*!******************************************************************************

  @file         hkb391.h

  ------------------------------------------------------------------------------

  @author       MartinB

  @brief        KB_LogSaveIterator

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HKB391_H
#define HKB391_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xf6\xf7\x51\x24\x39\x1c\xf2\x3b\x1d\x14\x60\xa3\x15\x79\x13\x0a'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gkb00.h"
#include "gkb03.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void kb391_InitLogSaveIterator (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Int2                           maxToBeRead,
    pasbool                              dbIsCold,
    pasbool                              forAutosave,
    pasbool                              completeLog,
    pasbool                              repeatable);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_FreeLog (
    tsp00_TaskId                         taskId,
    tgg00_BasisError      VAR_VALUE_REF  trError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_FreeLogForPipe (
    tsp00_TaskId                         taskId,
    const Log_IOSequenceNo&                 firstSavedIOsequence,
    const Log_IOSequenceNo&                 lastSavedIOsequence,
    tgg00_BasisError      VAR_VALUE_REF  trError);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_InvalidateSaveIterator ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_ReadNextLogpages (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tkb3_block_ptr                       queue_buffer,
    tsp00_Int2            VAR_VALUE_REF  num_read);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_GetSaveIterInfo (
    Kernel_Time&                         startTime,
    Kernel_Date&                         startDate,
    Kernel_Time&                         endTime,
    Kernel_Date&                         endDate,
    Log_IOSequenceNo&                    startIOSeq,
    Log_IOSequenceNo&                    endIOSeq,
    tsp00_Uint4           VAR_VALUE_REF  backupCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_GetNumOfPagesLeftForSegment (
    tsp00_Uint4           VAR_VALUE_REF  numOfUnsavedPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391_GetNumOfPagesLeftForLogDev (
    tsp00_Uint4           VAR_VALUE_REF  numOfUnsavedPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391_IOSeqIsInPage (
    const Log_IOSequenceNo&                 ioSequence,
    tkb00_Page            VAR_VALUE_REF  page);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391_IOSeqIsYoungerThanPage (
    const Log_IOSequenceNo&                 ioSequence,
    const Log_IOSequenceNo&                 oldestKnownIOSeq,
    tkb00_Page            VAR_VALUE_REF  page);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391InitializeWaitLists ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391ResumeAllWaitingTask (
    pasbool                              forAutosave);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391ResumeFirstWaitingTask (
    pasbool                              forRead,
    pasbool                              forAutosave);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391InsertWaitingTaskAtLast (
    tsp00_TaskId                         taskid,
    tgg00_WaitContext     VAR_VALUE_REF  waitcontext,
    pasbool                              forRead,
    pasbool                              forAutosave);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391Create_RTEConf_ParameterAccess (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Addr            VAR_VALUE_REF  params);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391AppendTo_RTEConf_ParameterAccess (
    RTEConf_Parameter&                   params,
    tkb3_xparam_page      VAR_VALUE_REF  xpPage);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_BasisError kb391CheckParameterForRestore (
    RTEConf_Parameter&                   params);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391Destroy_RTEConf_ParameterAccess (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Addr            VAR_VALUE_REF  params);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391SupressDBIdentCheckForMigration (
    tsp00_Version         VAR_ARRAY_REF  backupVersion);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb391CheckLogTapeAndDataCompatibility (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    const tkb00_Page&                    restartRecord,
    tsp00_Version         VAR_ARRAY_REF  backupVersion,
    tsp00_Line            VAR_ARRAY_REF  dbident,
    const Log_IOSequenceNo&                 firstIOSeq,
    const Log_IOSequenceNo&                 lastIOSeq);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb391_ValidLogSaveIterator ();

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

