#!/bin/sh
#
# Run all the nightly tests
#

CHRPERL=/devtool/local/bin/perl

export CHRPERL

PERL5LIB=/devtool/local/bin:/devtool/TOOL/tool/bin:/devtool/TOOL/tool/lib/perl5:/devtool/TOOL/tool/lib:/SAP_DB/TESTDB/lib:$PERL5LIB
export PERL5LIB

echo date
date

echo date \| cut -c 1-3
date | cut -c 1-3

######################################################################
# DIR 01
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 01
echo
$CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 01


######################################################################
# DIR 02
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 02
echo
$CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 02


######################################################################
# DIR 03
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 03
echo
$CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 03


######################################################################
# DIR 04
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 04
echo
$CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 04

######################################################################
# DIR 05
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 05
echo
$CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 05

######################################################################
# DIR 06
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 06
echo
$CHRPERL /SAP_DB/TESTDB/chr_destroy.pl -dir 06


######################################################################
# Nu aber wirklich sauber :-)
######################################################################
echo Execute rm -rf /SAP_DB/chr/0? /SAP_DB/chr/etc/0?
rm -rf /SAP_DB/chr/0? /SAP_DB/chr/etc/0?



######################################################################
# DIR 01 / 7500COR
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7500RAMP 
echo
$CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7500RAMP &
sleep 600

######################################################################
# DIR 02 / 7500DEV
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7500DEV 
echo
$CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7500DEV &
sleep 600

######################################################################
# DIR 03 / 7501DEV
######################################################################
if test ld0319 = `uname -a | cut -f 2 -d " "`; then
	echo Execute $CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7501DEV 
	echo 
	$CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7501DEV &
	sleep 600
fi

######################################################################
# DIR 04 / 7600DEV
######################################################################

if test 1 -ne `hostname | grep ds0116 | wc -l ` ; then
	echo Execute $CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7600DEV 
	$CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7600DEV &
	sleep 600
fi

######################################################################
# DIR 05 / 7403DEV
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7403DEV 
$CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7403DEV &
sleep 600


######################################################################
# DIR 05 / 7403COR
######################################################################
echo Execute $CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7403RAMP 
$CHRPERL /SAP_DB/TESTDB/chr_install.pl -package 7403RAMP &
sleep 600


######################################################################
# MUT LONG
######################################################################

#if test 1 -eq `uname -a | grep hs0030 | wc -l ` ; then 
#	$CHRPERL /SAP_DB/TESTDB/chr_single_test.pl -dir 01 -test mut_long &
#	sleep 600
#fi


######################################################################
# Check if we are in weekend and set appropriate parameters
######################################################################
if test Sat = `date | cut -c 1-3`; then
	TDAY=weekend
	SLTIME=36000
	
	#
	# Upgrade-Tests fr Martin Probst
	/devtool/local/bin/perl chr_create.pl -dir 06 -package 7600DEV &
	sleep 450
	/devtool/local/bin/perl chr_cmd_su.pl -dir 06 -cmd /SAP_DB/TESTDB/jt.sh &
	sleep 600
	#
else
	TDAY=workday
	SLTIME=3600
fi

export TDAY
export SLTIME
######################################################################
# /CHECK
######################################################################

echo Today is $TDAY

######################################################################
# DIR 01
######################################################################
echo $CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 01 -test_profile $TDAY &
echo
$CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 01 -test_profile $TDAY &
sleep $SLTIME


######################################################################
# DIR 02
######################################################################
echo $CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 02 -test_profile $TDAY &
echo
$CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 02 -test_profile $TDAY &
sleep $SLTIME


######################################################################
# DIR 03
######################################################################
echo $CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 03 -test_profile $TDAY &
echo
$CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 03 -test_profile $TDAY &
sleep $SLTIME


######################################################################
# DIR 04
######################################################################
echo $CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 04 -test_profile $TDAY
echo
$CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 04 -test_profile $TDAY &


######################################################################
# DIR 05
######################################################################
echo $CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 05 -test_profile $TDAY
echo
$CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 05 -test_profile $TDAY &



######################################################################
# DIR 06
######################################################################
#if test ld0319 = `uname -a | cut -f 2 -d " "`; then
echo $CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 06 -test_profile $TDAY
echo
$CHRPERL /SAP_DB/TESTDB/chr_test.pl -dir 06 -test_profile $TDAY 
#fi

