/*
 * mode-random.c
 *
 * Copyright 1998, 1999 Michael Elizabeth Chastain, <mailto:mec@shout.net>.
 * Licensed under the Gnu Public License, version 2.
 */

#include <stdio.h>
#include <stdlib.h>

#include "mconfig.h"



/*
 * Process a statement to give it a random answer.
 * Whee!
 */
static void 
scb_random(const statement_type * statement, void *p_UNUSED)
{
	switch (statement->verb) {
	default:
	case verb_NULL:
	case verb_IF:
		error_enum_bogus();

	case verb_MENU:
	case verb_mainmenu_name:
	case verb_comment:
	case verb_text:
		break;

	case verb_unset:
		{
			symbol_type    *symbol;

			for (symbol = statement->su_unset_list->symbol_first;
			     symbol != NULL;
			     symbol = symbol->next) {
				symbol->value = piece_empty;
				symbol->origin = origin_unset;
			}
		}
		break;

	case verb_def_bool:
	case verb_ask_hex:
	case verb_def_hex:
	case verb_dep_hex:
	case verb_ask_int:
	case verb_def_int:
	case verb_dep_int:
	case verb_ask_string:
	case verb_def_string:
	case verb_dep_string:
	case verb_def_tristate:
		{
			statement->sb_symbol->value = word_eval(statement->sb_def_value, 1);
			statement->sb_symbol->origin = origin_statement;
		}
		break;

	case verb_ask_bool:
	case verb_dep_bool:
	case verb_dep_mbool:
	case verb_ask_tristate:
	case verb_dep_tristate:
		{
			int             allowed = statement_bools_allowed(statement);
			int             ivalue;

			if ((allowed & 0x07) == 0)
				error_internal("scb_random: no value allowed");

			for (;;) {
				ivalue = rand() % 3;
				if (((1 << ivalue) & allowed) != 0)
					break;
			}

			statement->sb_symbol->value =
				(ivalue == 2) ? piece_y : (ivalue == 1) ? piece_m : piece_n;
			statement->sb_symbol->origin = origin_statement;
		}
		break;

	case verb_nchoice:
		{
			symbol_type    *symbol;

			int             index = (statement->sn_choice_count > 0)
			? (rand() % statement->sn_choice_count) : -1;
			statement->sn_choice_index = index;

			for (symbol = statement->sn_choice_list->symbol_first;
			     symbol != NULL;
			     symbol = symbol->next) {
				symbol->value = (index-- == 0) ? piece_y : piece_n;
				symbol->origin = origin_statement;
			}
		}
		break;

	}
}



/*
 * This mode is simple because it has no user interface.
 */
void 
do_mode_random(const block_type * block)
{
	const char     *str_error;

	srand(argument.useed);

	block_walk(block, 1, scb_random, NULL);

	if (block_output(block, &str_error) < 0) {
		fprintf(stderr, "Write failed: %s\n", str_error);
		exit(1);
	}
}
