# Artist: Hawkwind
# Song: Motorhead

@head {
	$tempo 86
	$time_sig 4/4
	$title "Hawkwind - motorhead"
}

@body {

	# bass

	%define main { /l8/e3 /l16/e /r2/r e /r2/r e /r2/r e /r2/r d d+ }
	%define main2 { /l8/e3 /l16/e /r2/r e /r2/r /l8/d d d /l16/d d+ }

	%define bridge { /l8/c3 c /l16/c c b2 /l8/a /l16/a /l8/a /l16/a a a b }
	%define bridge2 { /l8/c3 c /l16/c c /l8/c /l16/c c /l8/c
                          /l16/c c /l8/c /l16/b2 b /l8/b /l16/b b /l8/b
                          /l16/b b /l8/b /l16/b b /l8/b
	}

	%define chorus { /l8/e2 e /l16/e e /l8/e b2 b /l16/b b /l8/b }
	%define chorus2 { /l8/b2 b /l16/b b /l8/b }
	%define chorus3 { /l16/b2 b c3 c c+ c+ d d }

	@channel 1 bass {
		$patch 34 $volume 112
		/l16/d3 d+ # lead in
		%repeat 2 { ~main ~main2 }	# intro
		%repeat 3 {
			%repeat 6 { ~main }	    # verse (1st 2 bars no words)
			%repeat 2 { ~bridge } 	# "i should be tired" etc
			~bridge2 		        # "ain't...for an hour" etc
			%repeat 2 { ~chorus } 	# "motorhead..."
			%repeat 2 { ~chorus2 }	# "...alright"
			~chorus3		        # run back up to e
		}
	}

	# Drums

	%define drum_main { /l16/c3 r d r }

	@channel 10 drums {
		$volume 127 $reverb 64
		/l8/r /l1r4/r # rest for count in & intro
		%repeat 162 { ~drum_main }
	}

	# Cymbals

	%define cym_main { /l16/f+3 f+ g+ f+ }

	@channel 10 cymbals {
		$volume 64
		/l8/r /l1r4/r # rest for count in & intro
		%repeat 162 { ~cym_main }
	}
}
