/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.3 2004/08/27 18:32:51 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>
#if 0
#include <libxml/tree.h>
#endif

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of IpplWatch */
#if 0
#define DEBUG_SETDATA
#endif

int mdata_IpplWatch_to_xml(gzFile *fd, mdata *data) {
#define WR(x,f) \
	gzprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.ipplwatch->x, #x);
#define WRS(x) \
        if (data->data.ipplwatch->watches[x] != NULL) { \
                gzprintf(fd, "<watch num=\"%d\">\n", #x); \
		gzprintf(fd, "<timestamp>%d</timestamp>\n", data->data.ipplwatch->watches[x]->timestamp); \
		gzprintf(fd, "<data>%s</data>\n", data->data.ipplwatch->watches[x]->data); \
		gzprintf(fd, "<count>%ld</count>\n", data->data.ipplwatch->watches[x]->count); \
                gzprintf(fd, "</watch>\n"); \
        } else { \
                gzprintf(fd, "<watch num=\"%d\" />\n", #x); \
        }

	WR(count, d);
	WR(type, d);
	if (data->data.ipplwatch->count) {
		int i;
		gzprintf(fd, "<watches>" );
		for (i=0; i<data->data.ipplwatch->count; i++) {
			WRS(i);
		}
		gzprintf(fd, "</watches>\n" );
	} else {
		gzprintf(fd, "<watches />\n" );
	}
	return 0;
}

int mdata_IpplWatch_free(mdata *data) {
	int i;

	if (!data) return -1;
	if (data->type != M_DATA_TYPE_IPPLWATCH) return -1;

	if (data->data.ipplwatch->count) {
		for (i = 0; i < data->data.ipplwatch->count; i++ ) {
			if (data->data.ipplwatch->watches[i] == NULL)
				continue;
			if (data->data.ipplwatch->watches[i]->data) 
				free(data->data.ipplwatch->watches[i]->data);
			free(data->data.ipplwatch->watches[i]);
		}
	}
	free( data->data.ipplwatch->watches );
	
	return 0;
}

int mdata_IpplWatch_setdata(mdata *data, const char *str, time_t ts, char *dt, 
                            mdata_ipplwatch_type type, long count) {
#ifdef DEBUG_SETDATA
	fprintf(stderr, "%s.%d: mdata_IpplWatch_setdata() called!\n",
		__FILE__, __LINE__ );
#endif
	data->key = str;
	assert(data->key);
#ifdef DEBUG_SETDATA
	fprintf(stderr, "Setting data->key to '%s' ('%s')\n", data->key, str);
#endif

	if (data->type == M_DATA_TYPE_UNSET)
		data->type		= M_DATA_TYPE_IPPLWATCH;
#ifdef DEBUG_SETDATA
	fprintf(stderr, "Setting data->type to '%d'\n", data->type);
#endif

	data->data.ipplwatch->watches	= malloc( sizeof( mdata_ipplwatchelement *) );
#ifdef DEBUG_SETDATA
	fprintf(stderr, "Setting data->data.ipplwatch.watches to '%p'\n", data->data.ipplwatch->watches);
#endif
	data->data.ipplwatch->watches[0] = malloc( sizeof( mdata_ipplwatchelement));
	assert(data->data.ipplwatch->watches[0]);
	data->data.ipplwatch->watches[0]->timestamp	= ts;
	data->data.ipplwatch->watches[0]->data	= strdup(dt);
	data->data.ipplwatch->watches[0]->count	= count;
	data->data.ipplwatch->count	= 1;
#ifdef DEBUG_SETDATA
	fprintf(stderr, "Setting data->data.ipplwatch.count to '%d'\n", data->data.ipplwatch->count);
#endif
	data->data.ipplwatch->type	= type;
#ifdef DEBUG_SETDATA
	fprintf(stderr, "Setting data->data.ipplwatch.type to '%d'\n", data->data.ipplwatch->type);
#endif
	return 0;
}

int mdata_IpplWatch_from_xml(mstate_stack *m, int tagtype, const xmlChar *value, const xmlChar **attrs) {
	/* add your definitions here */
	/*
	const mdata_values data_values[] = {
		{ "grouped", M_DATA_FIELDTYPE_LONG},
		{ "count", M_DATA_FIELDTYPE_LONG},

		{ NULL, M_DATA_FIELDTYPE_UNSET}
	};
	*/

	return 0;
}



int mdata_IpplWatch_append(mdata *dst, mdata *src) {
	int i, j = dst->data.ipplwatch->count;
	
	for (i=0; i<src->data.ipplwatch->count; i++) {
		char *data;
		time_t ts;
		long count;
		int ii, updated = 0;
		mdata_ipplwatchelement **ndata;

		if (src->data.ipplwatch->watches[i] == NULL )
			continue;
		
		data = src->data.ipplwatch->watches[i]->data;
		ts = src->data.ipplwatch->watches[i]->timestamp;
		count = src->data.ipplwatch->watches[i]->count;
		
		for (ii=0; ii<j; ii++) {
			if (dst->data.ipplwatch->watches[ii] == NULL )
				continue;
		
			/* We are the same, we should only update timestamp and the count.. */
			if (!strcmp(dst->data.ipplwatch->watches[ii]->data, data)) {
				dst->data.ipplwatch->watches[ii]->timestamp = ts;
				dst->data.ipplwatch->watches[ii]->count++;
				updated = 1;
				break;
			}
		}

		if (updated)
			continue;
		
		/* No such data found -- we should append .. */
		ndata = realloc( dst->data.ipplwatch->watches, 
							  sizeof(mdata_ipplwatchelement*)*(j+1));

		/* realloc() failed -- out of memory ? */
		if( ndata == NULL ) {
			fprintf(stderr, "%s.%d: realloc() failed -- Out of memory?\n", 
				__FILE__, __LINE__);
			return -1;
		}
		
		ndata[j] = malloc( sizeof(mdata_ipplwatchelement) );
		ndata[j]->timestamp = ts;
		ndata[j]->data = strdup( data );
		ndata[j]->count = count;
		dst->data.ipplwatch->count++;
		dst->data.ipplwatch->watches = ndata;
	}
	
	return 0;
}

mdata *mdata_IpplWatch_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_IPPLWATCH;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */
	data->data.ipplwatch 	= malloc( sizeof( data_IpplWatch));
	memset(data->data.ipplwatch,0,sizeof(data_IpplWatch));

	data->data.ipplwatch->watches	= NULL;
	data->data.ipplwatch->type	= M_DATA_UNSET;
	data->data.ipplwatch->count	= 0;

	return data;
}

mdata *mdata_IpplWatch_copy(mdata *src) {
	mdata *data = mdata_IpplWatch_init();
	assert(data);

	mdata_IpplWatch_append(data, src);
	return data;
}

mdata *mdata_IpplWatch_create(const char *str, time_t ts, char *dt, int type, long count) {
	mdata *data = mdata_IpplWatch_init();
	assert(data);
	mdata_IpplWatch_setdata(data, str, ts, dt, type, count);

	return data;
}

/* end of IpplWatch */
