/* 
 *   Creation Date: <2002/01/11 01:56:01 samuel>
 *   Time-stamp: <2002/07/13 19:48:30 samuel>
 *   
 *	<init.c>
 *	
 *	
 *   
 *   Copyright (C) 2002 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "archinclude.h"
#include "version.h"
#include "alloc.h"
#include "misc.h"
#include "kernel_vars.h"

/************************************************************************/
/*	KExt magic, generated by Project Builder			*/
/************************************************************************/

#include <mach/mach_types.h>

extern kern_return_t _start(kmod_info_t *ki, void *data);
extern kern_return_t _stop(kmod_info_t *ki, void *data);
 
KMOD_EXPLICIT_DECL(com.IbriumHB.iokit.MolExt,  "1.0.0d1",  _start, _stop)
__private_extern__ kmod_start_func_t *_realmain = 0;
__private_extern__ kmod_stop_func_t *_antimain = 0;

#warning "XXXXXXXXXXXXXXXXXXXXXX FUNCTIONS UNIMPLEMENTED XXXXXXXXXXXXXXXXX"
/* THIS SHOULD BE FUNCTIONS... */
int clear_vsid_table;
int clear_tlb_table;
int flush_vsid_table;


/************************************************************************/
/*	init/cleanup module						*/
/************************************************************************/

int
init_module( void )
{
	if( common_init_module() )
		return 1;
#if 0
	write_hooks();
	printk("Hooks written (!)\n");
#endif
	return 0;
}

void
cleanup_module( void )
{
	common_cleanup_module();
	memory_allocator_cleanup();

	printk("Mol kernel extension unloaded\n");
}

void
inc_mod_count( void )
{
	// private_mod_count++;
}

void
dec_mod_count( void )
{
	// private_mod_count--;
}

/************************************************************************/
/*	Misc								*/
/************************************************************************/

kernel_vars_t *
alloc_kvar_pages( void )
{
	return (kernel_vars_t*)IOMallocAligned( NUM_KVARS_PAGES * 0x1000, 0x1000 );
}

void
free_kvar_pages( kernel_vars_t *kv )
{
	IOFreeAligned( kv, NUM_KVARS_PAGES * 0x1000 );
}
