/*	alg.h
 *
 *	Detect changes in a video stream.
 *	Copyright 2001 by Jeroen Vreeken (pe1rxq@amsat.org)
 *	This software is distributed under the GNU public license version 2
 *	See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_ALG_H
#define _INCLUDE_ALG_H

#include "motion.h"

struct coord {
	int x;
	int y;
	int width;
	int height;
};

struct segment {
	struct coord coord;
	int width;
	int height;
	int open;
	int count;
};

struct coord alg_locate_center (struct images *, int width, int height);
void alg_locate (struct coord *, struct images *, int width, int height, char *);
int alg_diff (struct context *, unsigned char *);
int alg_diff_standard (struct context *, unsigned char *);
int alg_lightswitch (struct context *, int diffs);
int alg_switchfilter (struct context *, int, struct coord *, char *);
void alg_noise_tune (struct context *, unsigned char *);
void alg_threshold_tune (struct context *, int, int);
int alg_despeckle (struct context *);
void tune_smartmask (struct context *);

#endif /* _INCLUDE_ALG_H */
