/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.DrawOrderComparator;
import base.drawable.Drawable;
import base.drawable.DrawnBox;
import base.drawable.DrawnBoxSet;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.topology.Arrow;
import base.topology.Line;
import base.topology.State;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Composite
extends Drawable {
    private static final int INIT_BYTESIZE = 2;
    private static final DrawOrderComparator DRAWING_ORDER = new DrawOrderComparator();
    private Primitive[] primes;
    private int last_prime_idx;

    public Composite() {
        this.primes = null;
    }

    public Composite(int n) {
        this.primes = new Primitive[n];
        this.last_prime_idx = this.primes.length - 1;
    }

    public Composite(Category category, int n) {
        super(category);
        this.primes = new Primitive[n];
        this.last_prime_idx = this.primes.length - 1;
    }

    public Composite(int n, double d, double d2, Primitive[] primitiveArray, byte[] byArray) {
        super(n, byArray);
        super.setEarliestTime(d);
        super.setLatestTime(d2);
        this.primes = primitiveArray;
    }

    public boolean resolveCategory(Map map) {
        boolean bl = super.resolveCategory(map);
        if (this.primes != null) {
            for (int i = this.primes.length - 1; i >= 0; --i) {
                Primitive primitive = this.primes[i];
                if (primitive == null) continue;
                boolean bl2 = primitive.resolveCategory(map);
                bl = bl && bl2;
            }
        }
        return bl;
    }

    public int getNumOfPrimitives() {
        if (this.primes != null) {
            return this.primes.length;
        }
        return 0;
    }

    public int getByteSize() {
        int n = super.getCategory() != null ? super.getByteSize() + 2 : 0;
        if (this.primes != null) {
            for (int i = this.primes.length - 1; i >= 0; --i) {
                n += this.primes[i].getByteSize();
            }
        }
        return n;
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        Arrays.sort(this.primes, DRAWING_ORDER);
        super.writeObject(mixedDataOutput);
        int n = this.primes.length;
        mixedDataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.primes[i].writeObject(mixedDataOutput);
        }
    }

    public Composite(MixedDataInput mixedDataInput) throws IOException {
        this.readObject(mixedDataInput);
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        super.readObject(mixedDataInput);
        short s = mixedDataInput.readShort();
        this.primes = new Primitive[s];
        for (int n = 0; n < this.primes.length; n = (int)((short)(n + 1))) {
            Primitive primitive = new Primitive(mixedDataInput);
            primitive.setParent(this);
            this.primes[n] = primitive;
            super.affectTimeBounds(primitive);
        }
        this.last_prime_idx = this.primes.length - 1;
    }

    public void setPrimitive(int n, Primitive primitive) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.primes.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + n + ", is out of range, [0.." + this.primes.length + "].");
        }
        this.primes[n] = primitive;
        super.affectTimeBounds(primitive);
    }

    public Primitive getPrimitive(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.primes.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + n + ", is out of range, [0.." + this.primes.length + "].");
        }
        return this.primes[n];
    }

    public void setPrimitives(Primitive[] primitiveArray) throws IllegalArgumentException {
        if (primitiveArray.length != this.primes.length) {
            throw new IllegalArgumentException("input array size, " + primitiveArray.length + ", is " + "different from the original, " + this.primes.length);
        }
        this.primes = primitiveArray;
        for (int i = this.primes.length - 1; i >= 0; --i) {
            super.affectTimeBounds(this.primes[i]);
        }
    }

    public Primitive[] getPrimitives() {
        return this.primes;
    }

    public Iterator timeLapIterator(TimeBoundingBox timeBoundingBox) {
        return new ItrOfPrimes(timeBoundingBox);
    }

    public SortedSet getSetOfPrimitiveLineIDs() {
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < this.primes.length; ++i) {
            treeSet.addAll(this.primes[i].getListOfVertexLineIDs());
        }
        return treeSet;
    }

    public Integer[] getArrayOfLineIDs() {
        SortedSet sortedSet = this.getSetOfPrimitiveLineIDs();
        Integer[] integerArray = new Integer[sortedSet.size()];
        sortedSet.toArray(integerArray);
        return integerArray;
    }

    public void setStartPrimitive(Primitive primitive) {
        this.primes[0] = primitive;
        super.affectTimeBounds(primitive);
    }

    public void setFinalPrimitive(Primitive primitive) {
        this.primes[this.last_prime_idx] = primitive;
        super.affectTimeBounds(primitive);
    }

    public Coord getStartVertex() {
        return this.primes[0].getStartVertex();
    }

    public Coord getFinalVertex() {
        return this.primes[this.last_prime_idx].getFinalVertex();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Composite[ " + super.toString() + " ");
        for (int i = 0; i < this.primes.length; ++i) {
            stringBuffer.append(this.primes[i].toString() + " ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isTimeOrdered() {
        if (!super.isTimeOrdered()) {
            System.err.println("**** Violation of Causality ****\nOffending Composite -> " + this);
            return false;
        }
        int n = this.primes.length;
        for (int i = 0; i < n; ++i) {
            Primitive primitive = this.primes[i];
            if (!primitive.isTimeOrdered()) {
                System.err.println("**** Internal Primitive Error ****\nIt is number " + i + " primitive " + "in the composite.");
                return false;
            }
            if (super.covers(primitive)) continue;
            System.err.println("**** Out of Composite Time Range ****\nOffending Primitive -> " + this + "\n" + "\t time coordinate " + i + " is out of range.");
            return false;
        }
        return true;
    }

    public void addPrimitivesToSet(Set set, TimeBoundingBox timeBoundingBox) {
        int n = this.primes.length;
        for (int i = 0; i < n; ++i) {
            Primitive primitive = this.primes[i];
            if (!primitive.overlaps(timeBoundingBox)) continue;
            set.add(primitive);
        }
    }

    public int drawState(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        int n = super.getRowID();
        float f = super.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        return State.draw((Graphics2D)graphics2D, (Color)colorAlpha, null, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastStatePos(n), (double)d, (float)f2, (double)d2, (float)f3);
    }

    public int drawArrow(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        int n = (Integer)map.get(new Integer(coord.lineID));
        int n2 = (Integer)map.get(new Integer(coord2.lineID));
        return Arrow.draw((Graphics2D)graphics2D, (Color)colorAlpha, null, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastArrowPos(n, n2), (double)d, (float)n, (double)d2, (float)n2);
    }

    public boolean isPixelInState(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        int n = super.getRowID();
        float f = super.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        return State.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f2, (double)d2, (float)f3);
    }

    public boolean isPixelOnArrow(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        float f = ((Integer)map.get(new Integer(coord.lineID))).floatValue();
        float f2 = ((Integer)map.get(new Integer(coord2.lineID))).floatValue();
        return Line.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f, (double)d2, (float)f2);
    }

    public boolean containSearchable() {
        return super.getCategory().isVisiblySearchable();
    }

    private class ItrOfPrimes
    implements Iterator {
        private TimeBoundingBox timeframe;
        private Primitive next_primitive;
        private int next_prime_idx;

        public ItrOfPrimes(TimeBoundingBox timeBoundingBox) {
            this.timeframe = timeBoundingBox;
            this.next_prime_idx = 0;
            this.next_primitive = Composite.this.primes != null ? this.getNextInQueue() : null;
        }

        private Primitive getNextInQueue() {
            while (this.next_prime_idx < Composite.this.primes.length) {
                if (!Composite.this.primes[this.next_prime_idx].overlaps(this.timeframe)) continue;
                Primitive primitive = Composite.this.primes[this.next_prime_idx];
                ++this.next_prime_idx;
                return primitive;
            }
            return null;
        }

        public boolean hasNext() {
            return this.next_primitive != null;
        }

        public Object next() {
            Primitive primitive = this.next_primitive;
            this.next_primitive = this.getNextInQueue();
            return primitive;
        }

        public void remove() {
        }
    }
}

