#ifndef MAXNAMELEN
#define MAXNAMELEN	80
#endif
#define DESCRIPLEN	120

/* error numbers for login overloading */

#define HOSTFULL	1	/* host reached maximum limit */
#define GROUPFULL	2	/* group reached maximum limit */
#define VSERVERFULL	3	/* virtual server reached maximum limit */
#define IPHOSTFULL	4	/* per ip limit for the host reached */
#define IPVSERVERFULL	5	/* per ip limit for the virtual server reached */

/* this will be used by sub-programs of muddleftpd to make sure it is running
   under the correct version of muddleftpd and it isn't accessing someone elses
   memory area */

#define CURRENTMAGIC	704198001

typedef struct
{
	int magic;
	int serverusercount;
	int servermaxcount;
	int groupareastart;
	int numvserver;
	int numgroups;
	int numrecs;
	pid_t pid;
} SHRMEMHEADER;

typedef struct
{
	char name[MAXSECTIONLEN];
	int count;
	int max;
} SHRMEMDATA;

typedef struct
{
	char username[MAXNAMELEN];
	char groupname[MAXSECTIONLEN];
	char vserver[MAXSECTIONLEN];
	char currentop[DESCRIPLEN];
	char remotehost[MAXNAMELEN];
	int pid;
	unsigned int ip;
} SCRFILEREC;

#define SCRF_USERNAME	0
#define SCRF_GROUPNAME	MAXNAMELEN
#define SCRF_VSERVER	SCRF_GROUPNAME + MAXSECTIONLEN
#define SCRF_CURRENTOP  SCRF_VSERVER + MAXSECTIONLEN
#define SCRF_REMOTEHOST SCRF_CURRENTOP + DESCRIPLEN
#define SCRF_PID	SCRF_REMOTEHOST + MAXNAMELEN

typedef struct
{
	char username[MAXNAMELEN];
	char currentop[DESCRIPLEN];
	char remotehost[MAXNAMELEN];
	int group;
	int vserver;
	volatile int pid;
	unsigned int ip;
} SCRMEMREC;

#define SHRMEMDATPOS(s,x)  ((SHRMEMDATA *)((char *)(s) + sizeof(SHRMEMHEADER)) + (x))

#define SHMEMSIZE 1024 * 1024
#define SHMEMPROCSTART 128 * 1024

