//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: confmport.h,v 1.3 2003/10/30 12:11:50 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __CONFMPORT_H__
#define __CONFMPORT_H__

#include <qwidget.h>
#include <qwhatsthis.h>

#include "midirawbase.h"
#include "synthconfigbase.h"

class QListView;
class QListViewItem;
class QPoint;
class QPopupMenu;
class QHeader;
class Xml;

//---------------------------------------------------------
//   MidiRawDeviceDialog
//---------------------------------------------------------

class MidiRawDeviceDialog : public MidiRawDeviceDialogBase {
      Q_OBJECT

   private slots:
      void deviceNew();
      void deviceDelete();
      void devicePath();
      virtual void accept();
      void editNameChanged(const QString& text);
      void editPathChanged(const QString& text);
      void speedChanged(const QString& text);
      void handshakingChanged(const QString& text);
      void typeChanged(const QString& text);
      void virtPortsChanged(int);
      void devicesSelectionChanged(QListViewItem*);

   public:
      MidiRawDeviceDialog(QWidget* parent = 0, const char* name = 0,
         bool modal = false, WFlags fl = 0);
      void populate();
      };

//---------------------------------------------------------
//   MPWhatsThis
//---------------------------------------------------------

class MPWhatsThis : public QWhatsThis {
      QHeader* header;

   protected:
      QString text(const QPoint&);

   public:
      MPWhatsThis(QWidget* parent, QHeader* h) : QWhatsThis(parent) {
            header = h;
            }
      };

//---------------------------------------------------------
//   MPConfig
//    Midi Port Config
//---------------------------------------------------------

class MPConfig : public SynthConfigBase {
      QPopupMenu* popup;
      QPopupMenu* instrPopup;
      MidiRawDeviceDialog* rdDialog;

      Q_OBJECT

   private slots:
      void rbClicked(QListViewItem*, const QPoint&,int);
      void songChanged(int);
      void addInstanceClicked();
      void removeInstanceClicked();

   public:
      MPConfig(QWidget* parent, char* name);
      };

#endif
