//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midirawin.h,v 1.1.1.1 2003/10/29 10:06:13 wschweer Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDIRAWIN_H__
#define __MIDIRAWIN_H__

//---------------------------------------------------------
//   MidiRawIn
//---------------------------------------------------------

class MidiRawIn {
      unsigned char* sysexMsg;
      int sysexSize;
      int sysexMaxSize;

      enum RecState { SYNC, CHANNEL, DATA1, DATA2, SYSEX, MTCQ,
            SONGPTR1, SONGPTR2, SONGSELECT};
      RecState recState;
      unsigned char recData1;
      void channelStatus(unsigned char c);

   protected:
      unsigned char recChannel;

      virtual void realtimeSystemInput(int) {}
      virtual void mtcInputQuarter(int)     {}
      virtual void setSongPosition(int)     {}
      virtual void eventReceived(int,int,int) {}
      virtual void sysexReceived(const unsigned char*, int) {}

   public:
      MidiRawIn();
      virtual ~MidiRawIn() {};
      void dataInput(unsigned char*, int);
      };

#endif

