#ifndef WIN32
#include <unistd.h>
#endif
#include <qapplication.h>
#include <qlabel.h>
#include <qfont.h>
#ifdef WIN32
#include <qwindowsstyle.h>
#else
#include <qstylefactory.h>
#endif
#include <qtranslator.h>
#include <qobject.h>

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "mainwindow.h"
#include "resource.h"
#include "mdiwindow.h"
#include "config.h"

void hide_argv(char *);

int main(int argc,char **argv)
{
	QApplication app(argc,argv);

	bool v = FALSE;

	QString host;
	QString user;
	QString password;
	int port = 3306;
	QString database;
	QString socket;
	QString timeout;

	if(argc > 2)
	{
		for(int z = 1; z < argc; z++)
		{
			if(argv[z][0] != '-')
				continue;
			
			switch(argv[z][1])
			{
				case 'h':
					host = argv[z + 1];
					hide_argv(argv[z + 1]);
					z++;
					break;
				case 'u':
					user = argv[z + 1];
					hide_argv(argv[z + 1]);
					z++;
					break;
				case 'p':
					password = argv[z + 1];
					hide_argv(argv[z + 1]);
					z++;
					break;
				case 'd':
					database = argv[z + 1];
					hide_argv(argv[z + 1]);
					z++;
					break;
				case 'P':
					port = atoi(argv[z + 1]);
					hide_argv(argv[z + 1]);
					z++;
					break;
				case 's':
					socket = argv[z + 1];
					hide_argv(argv[z + 1]);
					z++;
					break;
				case 't':
					timeout = argv[z + 1];
					hide_argv(argv[z + 1]);
					z++;
					break;
			}
		}

		if(!host.isEmpty() && !user.isEmpty())
			v = TRUE;
	}

#ifdef WIN32
	app.setStyle(new QWindowsStyle());
	app.setFont(QFont(QString::fromLocal8Bit("޸ڼü"), 8));
#endif

#ifndef WIN32
	umask(077);
#endif

	QTranslator z(0);
	z.load( "mysqlnavigator.qm", ".");
	app.installTranslator(&z);


	MainWindow *mysql = new MainWindow;

	mysql->setCaption(QObject::tr("MySQL Navigator ") + VERSION);

	app.setMainWidget(mysql);

	mysql->show();
	
	if(v)
		mysql->open_directly(host, user, password, database, port, socket, timeout);
	else
		mysql->slot_open();

	return  app.exec();
}

void hide_argv(char *value)
{
	for(unsigned int z = 0; z < strlen(value); z++)
		value[z] = '*';
}
