#include "edit.h"
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qpixmap.h>

void Edit::slot_new()
{
	File *s = new File(workspace,0,WDestructiveClose);

	s->flag = TRUE;

	connect(s, SIGNAL(signal_message(const QString &, int)), this, SLOT(slot_message(const QString &, int)));
	
	s->resize(400,350);
	
	s->setCaption("Noname");

	s->show();
}

void Edit::slot_open()
{
	QString s = QFileDialog::getOpenFileName(QString::null, QString::null, this);

	if(!s.isEmpty())
	{
		File *z= new File(workspace,0,WDestructiveClose);
		connect(z, SIGNAL(signal_message(const QString &, int)), this, SLOT(slot_message(const QString &, int)));
		z->resize(400,350);
		z->setCaption(s);
		z->load(s);

		z->flag = TRUE;

		z->show();
	}
	else
	{
		statusBar()->message("Loading aborted", 2000);
	}
}

void Edit::slot_save()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->save();
}

void Edit::slot_save_as()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->save_as();
}

void Edit::slot_print()
{
}

void Edit::slot_close()
{
	while((File *)workspace->activeWindow())
	{
		((File *)workspace->activeWindow())->close();
	}
	
	close();
}

void Edit::slot_message(const QString &message, int time)
{
	statusBar()->message(message, time);
}

void Edit::slot_undo()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->undo();
}

void Edit::slot_redo()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->redo();
}

void Edit::slot_cut()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->cut();
}

void Edit::slot_copy()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->copy();
}

void Edit::slot_paste()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->paste();
}

void Edit::slot_delete()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->clear();
}

void Edit::slot_select_all()
{
	if(workspace->activeWindow())
		((File *)workspace->activeWindow())->edit->selectAll();
}

void Edit::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is Edit"));	
}

void Edit::slot_xpm(const QString &xpm)
{
	workspace->setBackgroundPixmap(QPixmap(xpm));
}
