#include <qlistview.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qdatetime.h>
#include "key.h"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"

void 
KeyManager::slot_close()
{
	parentWidget()->close();
}

void
 KeyManager::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is Key"));
}

void 
KeyManager::slot_fire()
{
	if(database->currentText() == "mysql")
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), "Can't create key in mysql database");
		return;
	}

	if(mysql_select_db(mysql, database->currentText().latin1()))
		return;

	QString sql;

	sql += "alter table ";
	sql += table->currentText();
	sql += "\n";

	QListViewItemIterator s(key);

	for(; s.current(); s++)
	{
		sql += "add ";
		sql += s.current()->text(1);
		sql += " ";
		sql += s.current()->text(0);
		sql += "(";
		sql += s.current()->text(2);
		sql += "),\n";
	}

	sql = sql.stripWhiteSpace();

	if(sql.at(sql.length() - 1) == ',')
		sql = sql.left(sql.length() - 1);

	switch(QMessageBox::warning(this, tr("MySQL Navigator"), tr("The following query will create key. are you sure?") + "\n\n" + sql, "&Yes", "&No", "&Edit", 0, 1 ))
	{
			case 1: 
				return;
				break;
			case 2:
				((MainWindow *)qApp->mainWidget())->slot_query2(sql, database->currentText());
				return;
	}

	if(SQL::sql_query(sql.latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
	}
	else
	{
		emit signal_schema();
		QMessageBox::warning(this, tr("MySQL Navigator"), QString(tr(" Key has been successfully created.")));
		key->clear();
	}
}

void 
KeyManager::slot_new()
{
	key_name->setText("");
	key_type->setCurrentItem(0);
	key_name->setFocus();

	QListViewItemIterator s(field);
	for(; s.current(); s++)
		((QCheckListItem *)s.current())->setOn(FALSE);
}

void 
KeyManager::slot_save()
{
	if(key_name->text().isEmpty())
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter key name you will create.\n"));
		return;
	}

	if(is_exist(key_name->text()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Same key name already exists."));
			return;
	}
	
	QListViewItemIterator s(field);
	QString value;
	for(; s.current(); s++)
	{
		if(((QCheckListItem *)s.current())->isOn())
		{
			value += s.current()->text(0);
			value += ",";
		}
	}

	if(value.isEmpty())
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please choose fields."));
		return;
	}

	if(value.at(value.length() - 1) == ',')
		value = value.left(value.length()  - 1);
	
	QListViewItem *z = NULL;

	z = new QListViewItem(key, get_last());
	z->setText(0, key_name->text());
	z->setText(1, key_type->currentText());
	z->setText(2, value);

	slot_new();
}

void 
KeyManager::slot_drop()
{
	key->removeItem(key->selectedItem());
	key->clearSelection();
}

void 
KeyManager::slot_up()
{
	if(key->selectedItem() == NULL)
		return;

	if(key->firstChild() == NULL)
		return;

	QListViewItem *z = key->selectedItem()->itemAbove();

	if(z == NULL)
	{
		return;
	}

	z = z->itemAbove();

	if(z == NULL)
	{
		key->firstChild()->moveItem(key->selectedItem());
		return;
	}

	key->selectedItem()->moveItem(z);
}

void 
KeyManager::slot_down()
{
	if(key->selectedItem() == NULL)
		return;

	if(key->firstChild() == NULL)
		return;
	
	QListViewItem *z = key->selectedItem()->itemBelow();

	if(z == NULL)
	{
		return;
	}

	key->selectedItem()->moveItem(z);
}

QListViewItem *
KeyManager::get_last()
{
	QListViewItem *z;
	QListViewItem *last;

	z = key->firstChild();

	if(z == NULL)
	{
		return NULL;
	}

	last = z;
	
	while(TRUE)
	{
		z = z->itemBelow();

		if(z == NULL)
		{
			break;
		}

		last = z;
	}

	return last;
}

bool 
KeyManager::is_exist(QString name)
{
	QListViewItemIterator s(key);

	for(; s.current(); s++)
	{
		if(s.current()->text(0) == name)
			return TRUE;
	}

	return FALSE;
}

void 
KeyManager::slot_database()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();
	database->slot_value(value);
	slot_table(0);
}

void 
KeyManager::slot_table(int)
{
	MYSQL_RES *result;
    MYSQL_ROW row;
	QList<QString> value;

	table->clear();

	if(mysql_select_db(mysql, database->currentText().latin1()))
		return;

	result = mysql_list_tables(mysql, NULL);

	if(result == NULL)
	{
		return;
	}

    while((row = mysql_fetch_row(result)))
    {
		QString *s = new QString;
		*s = row[0];
		value.append(s);
        //table->insertItem(row[0]);
	}

	mysql_free_result(result);

	table->slot_value(value);

	slot_field(0);
}

void
KeyManager::slot_field(int)
{
	MYSQL_RES *result;
	MYSQL_FIELD *field;

	this->field->clear();

	if(table->currentText().isEmpty())
		return;

	if(mysql_select_db(mysql, database->currentText().latin1()))
		return;

	result = mysql_list_fields(mysql,table->currentText().latin1(),NULL);

	if(result == NULL)
		return;
	
	QCheckListItem *a = NULL;

	while((field = mysql_fetch_field(result)))
	{
		QCheckListItem *z = new QCheckListItem(this->field, field->name, QCheckListItem::CheckBox);
		z->moveItem(a);
		a = z;
	}
		
	mysql_free_result(result);
}

void 
KeyManager::slot_value(const QString &database, const QString &table)
{
	int z;

	for(z = 0; z < this->database->count(); z++)
	{
		if(this->database->text(z) == database)
		{
			this->database->setCurrentItem(z);
			this->database->data  = database;
			break;
		}
	}

	slot_table(0);

	for(z = 0; z < this->table->count(); z++)
	{
		if(this->table->text(z) == table)
		{
			this->table->setCurrentItem(z);
			this->table->data  = table;
			break;
		}
	}

	slot_field(0);
}

void
KeyManager::slot_clear()
{
	QListViewItemIterator s(field);
	for(; s.current(); s++)
		((QCheckListItem *)s.current())->setOn(FALSE);

	key->clear();
	key_type->setCurrentItem(0);
	key_name->setText("");
	key_name->setFocus();
}

void KeyManager::slot_clicked(int)
{
	QListViewItemIterator s(field);
	for(; s.current(); s++)
	{
		if(flag)
			((QCheckListItem *)s.current())->setOn(TRUE);
		else
			((QCheckListItem *)s.current())->setOn(FALSE);
	}

	if(flag)
		flag = FALSE;
	else
		flag = TRUE;
}