#include "server.h"
#include "mainwindow.h"
#include "serverlistviewitem.h"
#include "servernew.h"
#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qdom.h>
#include <qfile.h>
#include <stdlib.h>
#include <stdio.h>
#include <qpushbutton.h>
#include "config.h"
#ifndef WIN32
#include <unistd.h>
#endif

void MainWindow::slot_new()
{
	Server *server = new Server(TRUE, this, 0);
	
	server->show();	
}

void MainWindow::slot_open()
{
	Server *server = new Server(FALSE, this, 0);

	connect(server, SIGNAL(signal_server(const QString &, const QString &)), this, SLOT(slot_server(const QString &, const QString &)));

	server->show();
}

void MainWindow::slot_open2()
{
	ServerNew *server = new ServerNew(this, 0, TRUE);

	server->setCaption(tr("Quick Open"));

	server->fire->setText(tr("&Fire"));

	server->port->setText("3306");

	server->exec();

	if(server->flag)
	{
		QString host = "";
		QString user = "";
		QString password = "";
		QString port = "";
		QString database = "";
		QString socket = "";
		QString timeout = "";

		host = server->host->text();
		user = server->user->text();
		password = server->password->text();
		port = server->port->text();
		database = server->database->text();
		socket = server->socket->text();
		timeout = server->timeout->text();

		if(port.isEmpty())
			port = "3306";

		slot_quit();

		open_directly(host, user, password, database, port.toLong(), socket, timeout);
	}
 }

void MainWindow::slot_server(const QString &host, const QString &user)
{
	open = TRUE;
	sprintf(this->host, "%s", host.latin1());
	sprintf(this->user, "%s", user.latin1());
			
	statusBar()->message(tr("Connected..."),3000);

	setCaption(QObject::tr("MySQL Navigator ") + VERSION + " - " + host);

	if(option.log)
		log->show();
	else
		log->hide();

	if(option.schema)
		slot_schema2();	

	slot_database();

	enable_menu();

	load_query();
}

void MainWindow::open_directly(const QString &host, const QString &user, const QString &password, const QString &database, const int &port, const QString &socket, const QString &timeout)
{
	unsigned int v = timeout.toInt();

	mysql_options(&mysql, MYSQL_OPT_CONNECT_TIMEOUT , (char *)&v);

	if(!mysql_real_connect(&mysql,
							host.latin1(),
							user.latin1(),
							password.latin1(),
							database.latin1(),
							port,
							socket.latin1(),
							0	
							))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
	}
	else
	{
		sprintf(this->host, "%s@%s", user.latin1(), host.latin1());
		sprintf(this->user, "%s", user.latin1());

		open =  TRUE;

		statusBar()->message(tr("Connected..."),3000);

		setCaption(QObject::tr("MySQL Navigator ") + VERSION + " - " + user + "@" + host);

		if(option.log)
			log->show();
		else
			log->hide();
	
		if(option.schema)
			slot_schema2();	

		slot_database();

		enable_menu();

		load_query();
	}
}
