#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qlistview.h>
#include <qdatetime.h>
#include "process.h"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"

void Process::slot_close()
{
	parentWidget()->close();
}

void Process::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is Process"));
}

void Process::slot_kill()
{
	QListViewItemIterator z(process);
    
	for ( ; z.current(); ++z) 
	{
		if(((QCheckListItem *)z.current())->isOn())
		{
			if(mysql_kill(mysql, z.current()->text(0).toInt()))
			{
				QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
				break;
			}
		}
	}

	slot_process();
}

void Process::slot_reload()
{
	slot_process();
}

void Process::slot_process()
{
	MYSQL_RES *result;
	MYSQL_FIELD *field;
	MYSQL_ROW row;

	process->clear();

	int z;

	z = process->columns();

	for(int s = 0; s < z; s++)
	{
		process->removeColumn(0);
	}

	if(mysql_select_db(mysql, "mysql"))
		return;

	if(SQL::sql_query("show processlist"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return; 	 
	}

	result = mysql_store_result(mysql);

	if(result == NULL)
	{
		return;
	}
	
	z = mysql_num_fields(result);

	while((field = mysql_fetch_field(result)))
	{
		process->addColumn(field->name);
	}

	while((row = mysql_fetch_row(result)))
	{
		QCheckListItem *_s = new QCheckListItem(process, row[0], QCheckListItem::CheckBox);
		
		for(int s = 1; s < z; s++)
		{
			_s->setText(s, row[s]);
		}
	}

	mysql_free_result(result);
}

void Process::slot_timeout()
{
	slot_process();
}

void Process::slot_stop()
{
	timer.stop();
}