#ifndef SCHEMALISTVIEWITEM_H
#define SCHEMALISTVIEWITEM_H

#include <qlistview.h>

#define FLAG_HOST 0
#define FLAG_DATABASE_ROOT 1
#define FLAG_DATABASE 2
#define FLAG_TABLE 3
#define FLAG_FIELD 4
#define FLAG_USER_ROOT 5
#define FLAG_USER 6
#define FLAG_KEY 7
#define FLAG_FIELD_ROOT 8
#define FLAG_KEY_ROOT	9
#define FLAG_TABLE_ROOT 10

class SchemaListViewItem : public QListViewItem
{
public:
	SchemaListViewItem(QListView *, SchemaListViewItem *, const QString &title, const int flag, const QString &database = "", const QString &table = "", const QString &host = "", const QString &user = "");
	SchemaListViewItem(SchemaListViewItem *, SchemaListViewItem *, const QString &title, const int flag, const QString &database = "", const QString &table = "", const QString &host = "", const QString &user = "");
	~SchemaListViewItem();

	int flag;
	/*
	0: database
	1: table
	2: field
	0: user
	*/
	QString database;
	QString table;
	QString host;
	QString user;
		
protected:
	void paintCell(QPainter *si,const QColorGroup &color,int column,int width,int alignment);
};

#endif
