/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef __MYX_GRT_MYSQL_TRANSFORMATION_H_
#define __MYX_GRT_MYSQL_TRANSFORMATION_H_

#ifdef __cplusplus
extern "C" {
#endif

MYX_GRT_VALUE * generate_sql_create_statements(MYX_GRT_VALUE *param, void *data);
static void generate_sql_create_statements_assets(MYX_GRT_VALUE *schema, const char *assets_name, void *data);

MYX_GRT_VALUE *get_sql_create_script(MYX_GRT_VALUE *param, void *data);
static char *get_sql_create_script_assets(MYX_GRT_VALUE *schema, const char *assets_name);

MYX_GRT_VALUE *get_sql_create(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *get_sql_drop(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *get_sql_merge(MYX_GRT_VALUE *param, void *data);

static char * get_sql_create_schema(MYX_GRT *grt, MYX_GRT_VALUE *schema);
static char * get_sql_create_table(MYX_GRT *grt, MYX_GRT_VALUE *table);
static char * get_sql_create_view(MYX_GRT *grt, MYX_GRT_VALUE *view);
static char * get_sql_create_procedure(MYX_GRT *grt, MYX_GRT_VALUE *procedure);

static char * get_sql_drop_schema(MYX_GRT *grt, MYX_GRT_VALUE *schema);
static char * get_sql_drop_table(MYX_GRT *grt, MYX_GRT_VALUE *table);
static char * get_sql_drop_view(MYX_GRT *grt, MYX_GRT_VALUE *view);
static char * get_sql_drop_procedure(MYX_GRT *grt, MYX_GRT_VALUE *procedure);

#ifdef __cplusplus
}
#endif

#endif
