/* Copyright (C) 2003 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include <myx_qb_library.h>
#include <myx_aux_functions.h>

// needed from my_global.h, cant include it because of conflicts
#ifdef __GNUC__
typedef char    pchar;          /* Mixed prototypes can take char */
typedef char    puchar;         /* Mixed prototypes can take char */
typedef char    pbool;          /* Mixed prototypes can take char */
typedef short   pshort;         /* Mixed prototypes can take short int */
typedef float   pfloat;         /* Mixed prototypes can take float */
#endif

#include <m_ctype.h>

/*
 * functions
 */
#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
__declspec(dllexport) BOOL WINAPI DllMain(
    HINSTANCE hinstDLL,  // handle to DLL module
    DWORD fdwReason,     // reason for calling function
    LPVOID lpReserved )  // reserved
{
  // Perform actions based on the reason for calling.
  switch( fdwReason ) 
  { 
    case DLL_PROCESS_ATTACH:
      // Initialize once for each new process.
      // Return FALSE to fail DLL load.
      pcre_malloc= (void*(*)(size_t))g_malloc;
      pcre_free= g_free;
      break;

    case DLL_THREAD_ATTACH:
      // Do thread-specific initialization.
      break;

    case DLL_THREAD_DETACH:
      // Do thread-specific cleanup.
      break;

    case DLL_PROCESS_DETACH:
      // Perform any necessary cleanup.
      break;
  }
  return TRUE;  // Successful DLL_PROCESS_ATTACH.
}
#endif


int myx_get_qb_public_interface_version()
{
  return libmysqlqb_PUBLIC_INTERFACE_VERSION;
}

MYX_EXPLAIN_RESULT *myx_query_explain(MYSQL *mysql, const char *query)
{
  MYX_EXPLAIN_RESULT *result= NULL;
  MYSQL_RES *res;
  MYSQL_ROW row;
  char *tmp= g_strdup_printf("EXPLAIN %s", query);
  
  if (myx_mysql_query(mysql, tmp) < 0)
  {
    g_free(tmp);
    return NULL;
  }
  g_free(tmp);
  
  if ((res= mysql_store_result(mysql)))
  {
    unsigned int i= 0;
    
    result= g_malloc(sizeof(MYX_EXPLAIN_RESULT));
    
    result->rows_num= mysql_num_rows(res);
    result->rows= g_malloc(sizeof(MYX_EXPLAIN_ROW)*(gulong)result->rows_num);

    while ((row= mysql_fetch_row(res)))
    {
      MYX_EXPLAIN_ROW *expl= result->rows+i++;

      expl->id= g_strdup(row[0]);
      expl->select_type= g_strdup(row[1]);
      expl->table= g_strdup(row[2]);
      expl->join_type= g_strdup(row[3]);
      expl->possible_keys= row[4]?g_strsplit(row[4], ",", -1):NULL;
      expl->possible_keys_num= 0;
      if (expl->possible_keys)
        while (expl->possible_keys[expl->possible_keys_num])
          expl->possible_keys_num++;
      expl->key= g_strdup(row[5]);
      expl->key_len= g_strdup(row[6]);
      expl->ref= g_strdup(row[7]);
      expl->rows= g_strdup(row[8]);
      expl->extra= g_strdup(row[9]);
    }
  }

  return result;
}


int myx_free_explain_result(MYX_EXPLAIN_RESULT *res)
{
  unsigned int i;

  for (i= 0; i < res->rows_num; i++)
  {
    g_free(res->rows[i].id);
    g_free(res->rows[i].select_type);
    g_free(res->rows[i].table);
    g_free(res->rows[i].join_type);
    if (res->rows[i].possible_keys)
      g_strfreev(res->rows[i].possible_keys);
    g_free(res->rows[i].key);
    g_free(res->rows[i].key_len);
    g_free(res->rows[i].ref);
    g_free(res->rows[i].rows);
    g_free(res->rows[i].extra);
  }
  g_free(res->rows);
  g_free(res);

  return 0;  
}

