#ifndef INCLUDE_FSTEST_H
#define INCLUDE_FSTEST_H

#include "skills.h"

enum {NOFLUSH, MEANFLUSH, NICEFLUSH};

typedef struct testfile_t {
  char *filename;
  int fd;
  int chunks;  
  long int size;
} testfile;

int FileSystemMonitorAvailable(const char *options);
void FileSystemUseSkill( const char *options,
			 int *length,
			 SkillResult **results);

int fstest_runreadtest(char *, int, long, int, int, const char *, float *);
int fstest_runwritetest(char *, int, long, int, int, const char *, float *);

long timeread(char *, int, int, int, int, double *);
int flushbuffer(const char *, int);

void gen_filename(char *);
int createafile(char *, long);

void clockstart(struct timeval *);
void clockstop(struct timeval *, double *);


#endif
