///////////////////////////////////////////////////////////////////////////////
// $Id: PlayingDeck.hxx,v 1.1 1995/01/08 06:45:38 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// PlayingDeck.hxx - Oonsoo playing decks
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 13,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: PlayingDeck.hxx,v $
// Revision 1.1  1995/01/08  06:45:38  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef PLAYINGDECK_HXX
#define PLAYINGDECK_HXX

#include "Deck.hxx"
#include "Command.hxx"
#include "LinkedList.hxx"

class PlayingDeck : public Deck {
  private:
    Command* myCommand;

  protected:
    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

  public:
    // Construct an empty deck of playing cards
    PlayingDeck(ContainerWidget* parent, const char *const widgetName,
        int x, int y, int width, int maxHeight, SpriteCollection* sprites,
        Command* command);

    // Construct a partial deck of playing cards
    PlayingDeck(ContainerWidget* parent, const char *const widgetName,
        int x, int y, int width, int maxHeight, SpriteCollection* sprites,
        LinkedList<Card>* listOfCards, Command* command);

    // See if these cards form a legal oonsoo move
    int checkValidAddition(LinkedList<Card>* cards);

    // See if the deck consists of one complete suit in order
    int checkCompleteSuitInOrder();
 
    // Destructor
    virtual ~PlayingDeck();
};
#endif

