<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/widgets.php");
include_once("./functions/utils.php");
include_once("./functions/excelgen.class.inc");

//
// Simple Excel Export Plugin
//

$excelGen = new ExcelGen();
$rownum = 0;

/*
* The content type, when saved as file.
*/
function file_content_type()
{
	return "application/vnd.ms-excel";
}

/*
* The filename extension, when saved as file.
*/
function file_extension()
{
	return "xls";
}

/*
* The file header, when saved as file.
*/
function file_header($title)
{
	return NULL;
}

function prompt_header($headrow)
{
	global $excelGen, $rownum;
	
	if(is_not_empty_array($headrow))
	{
		$colnum = 0;
		while(list(,$headcolumn) = each($headrow))
		{
			$excelGen->WriteText( $rownum, $colnum++, $headcolumn );
		}
		$rownum++;
		
		return $excelGen->GetBuffer();
	}
	else
		return NULL;
}

function item_row($columns)
{
	global $excelGen, $rownum;
	
	if(is_not_empty_array($columns))
	{
		$colnum = 0;
		while(list(,$column) = each($columns))
		{
			$excelGen->WriteText( $rownum, $colnum++, $column );	
		}
		$rownum++;
		
		return $excelGen->GetBuffer();
	}
	else
		return NULL;
}

function close_export()
{
	global $excelGen;
	return $excelGen->Close();
}
?>
