<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/theme.php");
include_once("./functions/item_attribute.php");

function get_item_cover_image($item_id, $s_item_type, &$item_types_rs)
{
	global $CONFIG_VARS;
	
	if(strlen($item_types_rs[$s_item_type]['image'])==0)
	{
		$item_types_rs[$s_item_type]['image'] = fetch_sfieldtype_item_attribute_type($s_item_type, 'IMAGE');
	}
		
	$imageurl = fetch_attribute_val($item_id, $item_types_rs[$s_item_type]['image']);
	if(strlen($imageurl)==0 && strlen($CONFIG_VARS['listings.no_image'])>0)
	{
		// Theme based image.
		$imageurl = _theme_image_src($CONFIG_VARS['listings.no_image']);
	}
		
	if(strlen($imageurl))
	{
		$cover_image = "<img src=\"$imageurl\" border=0 ";
		if(strlen($CONFIG_VARS['listings.item_image_size'])>0)
			$cover_image .= $CONFIG_VARS['listings.item_image_size'];
		else
			$cover_image .= "width=\"100\" height=\"140\"";
		$cover_image .= ">";
			
		return $cover_image;
	}
	else
		return "&nbsp;";
}

function get_list_username($user_id, $mode, $allow_email=FALSE, $redirect_link=NULL, $redirect_url=NULL)
{
	global $HTTP_SESSION_VARS;
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	// Do not include email link, if Current User.
	if($user_id == $HTTP_SESSION_VARS['user_id'])
	{
		return replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", fetch_user_name($user_id)), 'user_id'=>$user_id), str_replace(" ", "&nbsp;", $LANG_VARS['current_user']));	
	}
	else
	{
		$user_name = replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", fetch_user_name($user_id)), 'user_id'=>$user_id), $LANG_VARS['user_name']);
		if($mode != 'printable' && $allow_email!==FALSE && is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
			return "<a href=\"email.php?op=send_to_uid&uid=".$user_id."&subject=".urlencode($LANG_VARS['no_subject'])."&redirect_link=".urlencode($redirect_link)."&redirect_url=".urlencode($redirect_url)."\" title=\"".htmlspecialchars($LANG_VARS['send_email'])."\">$user_name</a>";
		else
			return $user_name;
	}
}

/**
	Will split up a 'item_id_instance_no' value into
	its component item_id / instance_no or return FALSE.

	Format of input parameter:
		{item_id}_{instance_no}
*/
function get_item_id_and_instance_no($item_id_instance_no)
{
	if(strlen($item_id_instance_no)>0)
	{
		$splitidx = strpos($item_id_instance_no, "_");
    	if($splitidx !== FALSE)
		{
			$item_id = substr($item_id_instance_no,0,$splitidx);
			$instance_no = substr($item_id_instance_no,$splitidx+1);
			if(is_numeric($item_id) && is_numeric($instance_no))
				return array('item_id'=>$item_id,'instance_no'=>$instance_no);
		}
	}

	//else
	return FALSE;
}
?>
