<?php
/* 	
	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
*/
function theme_graph_config()
{
	return array('text'=>'000000',
				'captions'=>'000000',
				'lt_color'=>'6D78AB',
				'dk_color'=>'8E9DE0',
				'lt_border'=>'8E9DE0',
				'dk_border'=>'000000',
				'bgcolor'=>'FFFFFF',
				'transparent'=>FALSE);
}

/**
	It could just be an include("login.php"), which would also include
	the menu...

	No support for page title here!
*/
function theme_index()
{
	global $CONFIG_VARS;
	global $_OPENDB_THEME;
	
	return 
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n	<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</title>".
		"\n	<link rel=stylesheet type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		"\n</head>".
		"\n<frameset scrolling=\"yes\" cols=\"200,*\" border=\"5\" frameborder=\"5\">".
		"\n	<frame name=\"menu\" src=\"menu.php\">".
		"\n	<frame name=\"main\" src=\"login.php\">".
		"\n</frameset>".
		"\n</html>";
}

/**
*/
function theme_header($title)
{
	global $CONFIG_VARS;
	global $_OPENDB_THEME;
	
	return 
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n	<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</title>".
		"\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		"\n</head>".
		"\n<body>".
		"\n<div align=\"right\">".
		"\n<h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>".
		"\n</div>";
}

/**
*/
function theme_footer()
{
	return "\n</body>".
			"\n</html>";
}

/**
*/
function theme_menu()
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $_OPENDB_THEME;
	global $HTTP_SESSION_VARS;
	
	echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n	<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</title>".
		"\n	<link rel=stylesheet type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		"\n</head>".
		"\n<body class=\"menubar\">".
		"\n<div class=\"fineprint\">".
		"\n<img src=\"images/icon.gif\" alt=\"".$CONFIG_VARS['site.title']."\" align=bottom border=0>".
		"\n<i>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</i>".
		"\n</div>".
		"\n<br>");
	
	// Do not display user id if public_access is enabled.
	if(!is_site_public_access_enabled() && !empty($HTTP_SESSION_VARS['user_id']))
	{
	 	echo("\n".replace_lang_var("user_id", $HTTP_SESSION_VARS['user_id'], $LANG_VARS['uid_is_logged_in']).
			"<br>");
	}
	echo("\n<div class=\"menutext\"><br>");
	
	$menu_options = get_menu_options($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']);
	if(is_array($menu_options['normal']))
	{
		echo get_table_menu_options($menu_options['normal'], 1, "<b>%option%</b>", array('cellpadding'=>0,'cellspacing'=>0), "main");
	}

	if(is_array($menu_options['admin']))
	{
		echo("\n<br><hr>".
			"\n".$LANG_VARS['admin'].":<br><br>".
			get_table_menu_options($menu_options['admin'], 1, NULL, array('cellpadding'=>1,'cellspacing'=>0), "main").
			"\n<br>".
			"\n<p><div class=\"fineprint\"><i>".replace_lang_var("host", $CONFIG_VARS['db_server.dbname']."@".$CONFIG_VARS['db_server.host'], $LANG_VARS['connected_to'])."</i></div></p>");
	}
	
	echo("\n</div>");
	echo("\n</body>".
		"\n</html>");
}

/**
	Displays an error page.
*/
function theme_error($error)
{
	echo "\n<div class=\"error\">$error</div>";
}

/**
	This one has to return a string, because otherwise login.php
	will not work properly!
*/
function theme_refresh_menu()
{
	return "\n<script language=\"JavaScript\">\n".
		"parent.frames[0].location.reload();\n".
		"</script>\n";
}
?>
