/* Header file for H.263+ */

#define MB_SIZE 16

typedef struct pict_image {
  unsigned char *lum;        /* Luminance plane        */
  unsigned char *Cr;        /* Cr plane        */
  unsigned char *Cb;        /* Cb plane        */
} PictImage;

/* Structure for macroblock data */

typedef struct mb_structure {
  int lum[16][16];
  int Cr[8][8];
  int Cb[8][8];
} MB_Structure;

/* Picture structure */

typedef struct pict {
  int prev; 
  int curr;
  int TR;             /* Time reference */
  int bit_rate;
  int src_frame_rate;
  float target_frame_rate;
  int source_format;
  int picture_coding_type;
  int spare;
  //  int unrestricted_mv_mode;
  int PB;
  int QUANT;
  int DQUANT;
  //  int dquant_size;       /* dquant bit number when using modified quantization*/
  int MB;
  //  int seek_dist;        /* Motion vector search window */
  //  int use_gobsync;      /* flag for gob_sync */
  //  int MODB;             /* B-frame mode */
  //  int BQUANT;           /* which quantizer to use for B-MBs in PB-frame */
  //  int TRB;              /* Time reference for B-picture */
  //  float QP_mean;        /* mean quantizer */
  //  int EPTYPE;           /* use extended P-Type */
  //  int UFEP;             /* Update Full Extended PTYPE */
  //  int PCF;              /* Custom picture clock frequency */
  //  int PAR;              /* Pixel aspect ratio for custom format */
  //  int PWI;              /* Picture width indication for custom format */
  //  int PHI;              /* Picture height indication for custom format */
  //  int PAR_width;        /* Extended PAR width for custom format */
  //  int PAR_height;       /* Extended PAR height for custom format */
  //  int CCC;              /* Clock conversion code for custom picture clock*/
  //  int CD;               /* Clock divisor for custom picture clock */
  //  int rectangular_slice;    /* Slice structure submode */
  //  int arbitrary_slice_ordering;
  //  int ELNUM;            /* Enhancement layer number */
  //  int RLNUM;            /* Reference layer number */
  //  int MF;               /* Mode flags of reference picture selection */
  //  int reference_picture_selection;
  //  int TRPI;             /* Temporal reference for prediction indication */
  //  int TRP;              /* Temporal reference for prediction */
  //  int BCI;              /* Back channel message indication */
  //  int BCM;              /* Back channel message */
  //  int BCM_LENGTH;       /* Back channel message lenght */
  //  int RPRP;             /* Reference picture resampling parameters */     
  //  int RPRP_LENGTH;      /* Reference picture resampling parameters lenght */
  //  int PEI;              /* Extra insertion information, signals PSUPP */
  //  int PSUPP;            /* Supplemental Information (Annex L) */  
  //  int Intra_Mode;       /* Intra Mode for advanced Intra Coding */
  //  int RTYPE;            /* Rounding type for P-pictures */
} Pict;


struct ENCODER_STATE {
  PictImage     *prev_image;
  PictImage     *curr_image;
  PictImage     *curr_recon;
  PictImage     *prev_recon;

  /* To be used for temporal scalability. */
  PictImage     *next_P_image;
  PictImage     *next_P_recon;
  PictImage     *prev_P_image;
  PictImage     *prev_P_recon;

  Pict          *pic;
  unsigned char *image;

};
MB_Structure *data;
struct ENCODER_STATE *h263_init_encoder();
void h263_encode_one_frame(struct ENCODER_STATE *s, int i, int tr);
void h263_cleanup(struct ENCODER_STATE *s);
PictImage * InitImage (int size);
