/*
 * vic2jfif.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/file.h>

#include "../vic-1/packet.h"

struct hdr {
	int cc;
	struct vicfrm_jpg ph;
};

grab(int fd, u_char* buffer)
{
	int cc;
	u_char *ip;
	struct hdr* p = (struct hdr*)buffer;

	cc = read(fd, (char*)buffer, sizeof(*p));
	if (cc < 0) {
		perror("read");
		exit(1);
	}
	if (cc < sizeof(*p))
		return (-1);
	cc = ntohl(p->cc);
	if (cc < 0 || cc > 100000) {
		fprintf(stderr, "impossible length\n");
		exit(1);
	}
	cc -= sizeof(struct vicfrm_jpg);
	ip = (char *)(p + 1);
	if (read(fd, (char*)ip, cc) <= 0)
		return (-1);

	/* Remove the trailing zeros inserted by the DMA process */
	ip += cc;
	if (ip[-1] == 0) {
		while(*--ip == 0)
			;
		ip += 2;
	}
	*ip++ = 0xff;
	*ip++ = 0xd9;/* EOI */

	return (ip - buffer);
}

/*
 * Write the first frame of a vic dump file to
 * stdout, as a JFIF format file.
 */
main(int argc, char **argv)
{
	int fd, cc;
	int start = 0;
	int end = 0;
	struct hdr *h;
	u_char *p;
	int op, n;
	extern int optind, opterr;
	extern char *optarg;
	char *ofile = "out";
	u_char buffer[32 * 1024];

	opterr = 0;
	while ((op = getopt(argc, argv, "n:s:e:o:")) != -1) {
		switch (op) {

		case 'n':
			start = end = atoi(optarg);
			break;

		case 's':
			start = atoi(optarg);
			break;

		case 'e':
			end = atoi(optarg);
			break;

		case 'o':
			ofile = optarg;
			if (strlen(ofile) > 200)
				exit(1);
			break;
		}
	}
	argc -= optind;
	argv += optind;

	if (argc != 1)
		exit(1);

	fd = open(*argv, O_RDONLY);
	if (fd < 0) {
		perror(*argv);
		exit(1);
	}
	n = 0;
	while ((cc = grab(fd, buffer)) > 0) {
		int out;
		char fname[256];

		++n;
		if (n < start)
			continue;
		if (n > end)
			break;

		sprintf(fname, "%s-%02d.jpg", ofile, n);
		out = open(fname, O_WRONLY|O_CREAT|O_TRUNC, 0644);
		if (out < 0) {
			perror(fname);
			exit(1);
		}

		h = (struct hdr *)buffer;
		dumpJfifFrame(out, (char *)(h + 1), cc - sizeof(*h),
			      ntohs(h->ph.width), ntohs(h->ph.height),
			      ntohs(h->ph.quantization), 0);
		close(out);
	}
	close(fd);

	exit(0);
}
