/*
 * mb-mgr.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-mgr.h,v 1.13 2002/02/03 03:16:30 lim Exp $
 */

#ifndef _MBMGR_H_
#define _MBMGR_H_

#include "mb/mb.h"
#include "mb/mb-obj.h"
#include "mb/mb-canv.h"


class MBLocalReceiver;

//
// handles network calls, keep track of receivers and senders etc.
//
class MBManager : public MBBaseMgr {
public:
	MBManager();
	virtual ~MBManager();

	virtual int command(int argc, const char*const* argv);

	virtual void handle_request(const SrcId& sidRqtSrc, Byte *pb, int len);
	virtual void handle_reply(const SrcId& sidRpySrc, Byte *pb, int len);

	/* creates a local receiver */
	MBLocalReceiver *CreateLocal();

	/* register a tcl command to invoke when creating a new canvas */
	void attachUI(const char* szUIObj) {
		if (pObjUI_) {
			Tcl_DecrRefCount(pObjUI_);
		}
		// we will append parameters, so better to add space
		// now
		pObjUI_ = Tcl_NewStringObj((char*)szUIObj, -1);
		Tcl_IncrRefCount(pObjUI_);
	}

	/* Returns time of day, in 10ms units */
	/* NOTE: wrap around time is a big problem, but we are
	 *       ignoring this at the moment */
	ulong CurrTime() const {
		struct timeval tv;
		gettimeofday(&tv, 0);
		MBTime t;
		tod2mb(tv, t);
		return t;
	}

	void resetTime() {
		pLastActiveCmd_ = 0;
	}

	// finds the most recent item just before the given timestamp
	CanvItemId FindMostRecent(PageId pid, n_long timestamp);

	// virtual SRM_AppMgr functions
	virtual int next_ADU(u_char *db, int len, srm_src &id, int &pkt_type,
			     int &next);

	// the page is about to be hidden
	void ChangeStatus(const PageId& pgid, Bool isVisible);
	virtual void Rearrange(MBPageObject *pPage, MBCmd *pCmd);

	/* time traversal */
	int warpTime(const PageId &pgId, const MBTime& t);
	int timeRange(const PageId &pgId, MBTime& start, MBTime& end);

protected:
	virtual MBBaseRcvr   *NewReceiver(const SrcId &srcId, Bool isLocal);
	virtual MBPageObject *NewPageObject(const PageId &pageId,
					    Bool newPage);
	void LocalRcvr(MBLocalReceiver *rcvr) { pLocalRcvr_ = rcvr; }
	void LocalSid(const SrcId &sid) { local_sid_ = sid; }
private:
	virtual int periodic_update(u_char *buf);

	virtual Bool isVisible(const PageId &pgId);
	virtual void activity(MBPageObject *pPage, MBCmd* pCmd);
	virtual void notifyCurrPage(const SrcId& srcId,const PageId& pgId);

	SrcId local_sid_;
	MBLocalReceiver *pLocalRcvr_;
	Tcl_Obj* pObjUI_;

	/* source action announcement state */
	static int sourceActionInterval_;
	MBCmd* pLastActiveCmd_;
	int lastSourceActiveTime_;

	/* page action announcement state */
	static int pageActionInterval_;
	MBPageObject* pLastActivePage_;
	int lastPageActiveTime_;

	/* source id of a source we are tracking */
	SrcId trackSrcId_;
};

#endif /* #ifdef _MBMGR_H_ */
