/*
 * mbv2-obj.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mbv2/mbv2-obj.h,v 1.8 2002/02/03 03:17:08 lim Exp $
 */

#ifndef MASH_MBV2_OBJ_H
#define MASH_MBV2_OBJ_H


#include "mbv2.h"
#include "linkedlist.h"
#include "array.h"

class MBv2Session;
class MBv2Source;
class MBv2Page;
class MBv2Cmd;
class MBv2Canvas;

class MBv2Source : public TclObject {
public:
	MBv2Source();
	virtual ~MBv2Source();

	MBv2Session *session() { return session_; }
	srm_source_t srm_source() { return srm_source_; }
	void recv(unsigned int cid, unsigned int seqno,
		  const unsigned char *data, int len,const srm_adu_info *info);
	void recv_cid(unsigned int cid, const unsigned char *name,
		      int name_len);
	void read_adu(unsigned int cid, unsigned int seqno,
		      unsigned char **data_ptr, unsigned int *len_ptr,
		      srm_free_proc *free_proc_ptr,
		      srm_adu_info *info);
	Bool dispatch(MBv2Page *page, MBv2Cmd *cmd);

	MBv2Page *create_page(u_int32_t cid, const MBv2PageId &pageid);
	MBv2Page *create_page(const MBv2PageId &pageid);
	MBv2Page *find_page(u_int32_t cid);
	MBv2Page *find_page(const MBv2PageId &pageid);

	// redefine the following function in a subclass if you like
	virtual Bool is_visible(const MBv2PageId& /*pageid*/) { return 1; }

	void defer_cmd(MBv2Page *page, MBv2Cmd *cmd, MBv2Dependency *dep);

	int init(int argc, const char * const *argv);
	int source_id(int argc, const char * const *argv);
	int session(int argc, const char * const *argv);
private:
	void flush_deferred(u_int32_t cid, MBv2Page *page);

	MBv2Session *session_;
	srm_source_t srm_source_;
	Tcl_HashTable htPages_, htPageIds_;

	struct MBv2SaveDependency {
		MBv2Page *page;
		MBv2Cmd *cmd;
		MBv2Dependency dep;

		// sort this one by dep.cid
		int compare(const struct MBv2SaveDependency &d) const {
			if (dep.cid < d.dep.cid) return -1;
			if (dep.cid ==d.dep.cid) return 0;
			return 1;
		}
	};
	List<MBv2SaveDependency> deferredCmds_;
};


class MBv2Page {
public:
	MBv2Page(MBv2Source *src, u_int32_t cid, const MBv2PageId &pageid);
	~MBv2Page();

	inline MBv2Canvas *canvas() { return canvas_; }
	inline void canvas(MBv2Canvas *c) { canvas_ = c; }

	void insert(MBv2Cmd *cmd);
	Bool execute(MBv2Cmd *cmd, Bool inFlushDeferred=0);
	void defer_cmd(MBv2Page *page, MBv2Cmd *cmd, MBv2Dependency *dep);

	MBv2CanvId find_most_recent(MBv2Time& mostRecent,
				    const MBv2Time &timestamp);
	void schedule_recovery();
	const MBv2PageId &id() { return id_; }
	u_int32_t cid() { return cid_; }

	MBv2Source *source() { return src_; }
	inline Bool is_local()
	{ return srm_is_local_source(src_->srm_source()); }
	inline Bool is_visible();
	inline Bool have_cmd(MBv2CmdId cmdId)
	{ return (nextCmdId_ > cmdId && cmds_[cmdId]!=NULL); }
	inline MBv2Cmd *cmd(MBv2CmdId cmdId)
	{ return ((nextCmdId_ > cmdId) ? cmds_[cmdId] : ((MBv2Cmd*)NULL)); }
	inline MBv2CmdId max_cmdid() { return nextCmdId_; }

	MBv2CanvId get_canvas_item(MBv2CmdId cmdid);
	MBv2CmdId  get_cmdid(MBv2CanvId canvid);
	void forget_canvas_item(MBv2CmdId cmdid);
	void associate_canvas_item(MBv2CmdId cmdid, MBv2CanvId canvId);

	void tag(MBv2Cmd *cmd, MBv2CmdId tagid);
	MBv2CmdId tag2cmd(MBv2CmdId tagid);
private:
	void flush_deferred(MBv2CmdId just_rcvd);
	void update_deferred(MBv2Cmd *cmd, MBv2Dependency *dep);

	Array<MBv2Cmd*> cmds_;
	MBv2CmdId  nextCmdId_, firstHole_;
	MBv2Source *src_;
	u_int32_t cid_;
	MBv2PageId id_;
	MBv2Canvas *canvas_;
	MBv2CmdId  tagCnt_;

	Tcl_HashTable htCmd2CanvId_, htCanvId2Cmd_, htTag2Cmd_;

	struct MBv2SaveDependency {
		MBv2Page *page;
		MBv2Cmd  *cmd;
		MBv2Dependency dep;

		// sort by dep.cmd followed by dep.degree
		int compare(const struct MBv2SaveDependency &d) const {
			if (dep.cmd < d.dep.cmd ||
			    (dep.cmd==d.dep.cmd && dep.degree <d.dep.degree))
				return -1;
			if (dep.cmd==d.dep.cmd && dep.degree==d.dep.degree)
				return 0;
			return 1;
		}
	};

	List<MBv2SaveDependency> deferredCmds_;
};


class MBv2Session : public TclObject {
public:
	MBv2Session();
	~MBv2Session();
	srm_session_t srm_session() { return srm_session_; }
	inline Bool is_visible(const MBv2PageId &pageid);
	MBv2Canvas *get_canvas(const MBv2PageId &pageid);
	void rearrange(MBv2Page *page, MBv2Cmd *cmd);
	void activity (MBv2Page *page, MBv2Cmd *cmd);

	MBv2Source * source(srm_source_t source);
	Bool source(srm_source_t s1, MBv2Source *s2);

	int init (int argc, const char * const *argv);
	int reset(int argc, const char * const *argv);
	int find_owner(int argc, const char * const *argv);
	int drop_probability(int argc, const char * const *argv);

	// the following function is called only by mbv2
	// an RMX need not set this; the sender_ field is used only
	// in the is_visible() method
	int sender(int argc, const char * const *argv);

	inline unsigned char *adu_buf(int &size)
	{ size = adu_buf_size_; return adu_buf_; }
	inline unsigned char *resize_adu_buf(int size)
	{
		if (size <= adu_buf_size_) return adu_buf_;
		if (adu_buf_) delete [] adu_buf_;
		adu_buf_ = new unsigned char [size];
		adu_buf_size_ = size;
		return adu_buf_;
	}
private:
	MBv2CanvId find_most_recent(MBv2PageId pageid,
				    const MBv2Time &timestamp);

	void do_activity();
	static void delayed_activity(ClientData cd);
	static MBv2Source* get_source(srm_source_t source);
	static void recv(srm_source_t source,
			 unsigned int cid, unsigned int seqno,
			 const unsigned char *data, int len,
			 const srm_adu_info *info);
	static int should_recover(srm_source_t source,
				  unsigned int cid, unsigned int sseq,
				  unsigned int eseq);
	static void read_adu(srm_source_t source,
			     unsigned int cid, unsigned int seqno,
			     unsigned char **data_ptr, unsigned int *len_ptr,
			     srm_free_proc *free_proc_ptr,
			     srm_adu_info *info);
	static void source_update(srm_source_t source,
				  const unsigned char *info,
				  int info_len);
	static void recv_cid(srm_source_t source, unsigned int cid,
			     unsigned int /*parent*/,
			     const unsigned char *name, int name_len);

	srm_session_t srm_session_;
	Tcl_HashTable htSrcs_;

	MBv2Source *sender_; /* this field is used only by is_visible() */
	unsigned char *adu_buf_;
	int adu_buf_size_;

	MBv2Page *lastActivePage_;
	MBv2Cmd  *lastActiveCmd_;
	MBv2Time lastActiveTime_;
	Tcl_TimerToken lastActiveTimerId_;
};


inline Bool MBv2Session::is_visible(const MBv2PageId &pageid) {
	/* if there is no sender object always assume visible */
	return (sender_ ? sender_->is_visible(pageid) : 1);
}


inline Bool MBv2Page::is_visible() { return src_->session()->is_visible(id_); }


#endif /* #ifdef MASH_MBV2_OBJ_H */
