/*
 * ps-dps.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/ps/ps-dps.cc,v 1.5 2002/02/03 04:14:18 lim Exp $";
#endif

#include <osfcn.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>

#include <InterViews/action.h>
#include <InterViews/session.h>
#include <InterViews/display.h>
#include <InterViews/window.h>
#include <InterViews/raster.h>
#include <Dispatch/dispatcher.h>
#include <Dispatch/iohandler.h>

/* FIXME interviews abstraction violation */
#include <IV-X11/xraster.h>
#include <IV-X11/xdisplay.h>
#include <IV-X11/xwindow.h>
#include <IV-X11/Xlib.h>

#ifdef __osf__
#define DPSPrintf xxxDPSPrintf

#include <IV-X11/Xdefs.h>
#include <DPS/XDPSlib.h>
#include <DPS/dpsXclient.h>
#include <DPS/dpsexcept.h>
#include <IV-X11/Xundefs.h>

#undef DPSPrintf
extern "C" void DPSPrintf(DPSContext, const char *fmt, ...);

#else

#include <IV-X11/Xdefs.h>
extern "C" {
#include <DPS/XDPSlib.h>
#include <DPS/dpsXclient.h>
#include <DPS/dpsexcept.h>
}
#include <IV-X11/Xundefs.h>
#endif


#include "dps-ps.h"
#include "msgwin.h"
#include "drawop.h"
#include "view.h"

static const char* dpsinit =
   "userdict maxlength dict begin\n\
    /$brkpage{}def\n\
    /wb$defmatrix %g 0 0 -%g 0 0 matrix astore def\n\
    /defaultmatrix{wb$defmatrix exch copy}bind def\n\
    /initmatrix{wb$defmatrix setmatrix}bind def\n\
    /wb$initgraphics_ /initgraphics load def\n\
    /initgraphics{wb$initgraphics_ initmatrix\n\
      0 0 moveto %g 0 rlineto 0 %g rlineto %g 0 rlineto closepath clip\n\
      newpath}bind def\n\
    showpage initgraphics\n\
    /_$wb$showpage /showpage load def\n\
    /showpage {clientsync}bind def\n\
    /erasepage {showpage}bind def\n\
    /copypage {showpage}bind def\n\
    /setdevparams{pop pop}bind def\n\
    /setpagedevice{pop}bind def\n\
    /setsystemparams{pop}bind def\n";

static DPSinterp* interp;
static DPSContext dpsctx;
static XScreen* curscreen;

static void dps_recv(DPSContext ctx, char* buf, u_int len)
{
	fwrite(buf, 1, len, stdout);
	fflush(stdout);
}

extern int dps_use_color;

static DPSContext create_context(XWindow pixmapID, GC gc, int height)
{
	Display* display = Session::instance()->default_display();
	XDisplay* dpy = display->rep()->display_;
	if (dps_use_color)
		return (XDPSCreateSimpleContext(dpy, pixmapID, gc, 0, height,
						(void(*)())dps_recv,
						(void(*)())DPSDefaultErrorProc,
						NULL));
	/*
	 * Allocate a grayramp for the DPS interpreter.  We don't do
	 * anything fancy (like search through the colormap to see
	 * if such a ramp already exists).  This is the same ramp
	 * used by nv and vic, and our modified tk/interviews libraries,
	 * so all though we allocate colors r/w other applications
	 * can share them if wb is started first.
	 */
	static XStandardColormap grayramp;
	static XStandardColormap graycube;
	static int first = 1;
	if (first) {
		first = 0;
		WindowVisual* wv = display->rep()->default_visual_;
#define GREY_LEVELS 32
		u_long pix[GREY_LEVELS];
		XColor colors[GREY_LEVELS];
		if (XAllocColorCells(dpy, wv->colormap(), 1, 0, 0,
				     pix, GREY_LEVELS) == 0) {
			/*FIXME use black/white ramp? */
			fprintf(stderr, "wb: couldn't allocate gray ramp\n");
			return (0);
		}
		for (int i = 0; i < GREY_LEVELS; ++i) {
			XColor& xc = colors[i];
			int level = (i + 1) * 65536/GREY_LEVELS - 1;
			xc.red = xc.green = xc.blue = level;
			xc.flags = DoRed | DoGreen | DoBlue;
			xc.pixel = pix[i];
		}
		XStoreColors(dpy, wv->colormap(), colors, GREY_LEVELS);
		/*
		 * DPS seems to use only the red component of the
		 * gray ramp.  Would be nice if they documented this.
		 * It would be better to set red_max = 9, green_max = 18,
		 * blue_max = 4 so that we'd have an rgb to luminance
		 * conversion built into the ramp.
		 */
		grayramp.colormap = wv->colormap();
		grayramp.red_max = 31;
		grayramp.red_mult = 1;
		grayramp.blue_max = 0;
		grayramp.blue_mult = 0;
		grayramp.green_max = 0;
		grayramp.green_mult = 0;
		grayramp.base_pixel = pix[0];
		grayramp.visualid = wv->visual()->visualid;
		grayramp.killid = 0;/*FIXME?*/

		graycube.colormap = wv->colormap();
		graycube.red_max = 9;
		graycube.red_mult = 1;
		graycube.blue_max = 4;
		graycube.blue_mult = 1;
		graycube.green_max = 18;
		graycube.green_mult = 1;
		graycube.base_pixel = pix[0];
		graycube.visualid = wv->visual()->visualid;
		graycube.killid = 0;/*FIXME?*/
	} else if (grayramp.red_max == 0)
		/*
		 * Had an error on first call.
		 */
		return (0);

	return (XDPSCreateContext(dpy, pixmapID, gc,
				  0, height,
				  0, &grayramp, &graycube, 0,
				  (void(*)())dps_recv,
				  (void(*)())DPSDefaultErrorProc, NULL));
}

static void dps_stathandler(DPSContext ctx, int status)
{
	switch (status) {
	case PSRUNNING:
	case PSNEEDSINPUT:
	default:
		fprintf(stderr, "wb: unexpected DPS status %d\n", status);
		/*fall through*/

	case PSFROZEN:
		// XDPSUnfreezeContext(ctx);
	case PSZOMBIE:
		DPSDestroySpace(ctx->space);
		dpsctx = 0;
		if (interp)
			interp->page_done();
	}
}

static int dps_available = -1;

static int masktoshift(int m)
{
	if (m == 0)
		abort();
	int n = 0;
	while ((m & 1) == 0) {
		++n;
		m >>= 1;
	}
	return (n);
}

DPSinterp::DPSinterp()
{
	if (dps_available == -1) {
		/* see if server supports DPS */
		Display* display = Session::instance()->default_display();
		XDisplay* dpy = display->rep()->display_;
		/*
		 * use root window instead of "None" to work around
		 * an irix-3.5 dps bug
		 */
		XWindow w = RootWindow(dpy, DefaultScreen(dpy));
		GC gc = DefaultGC(dpy, DefaultScreen(dpy));
		dpsctx = create_context(w, gc, 0);
		if (dpsctx == NULL) {
			dps_available = 0;
		} else {
			dps_available = 1;
			DPSDestroySpace(dpsctx->space);
			dpsctx = 0;
		}
	}
}

int DPSinterp::available()
{
	return (dps_available);
}

int DPSinterp::send(DrawOpPSComp* o, View* v, PSstream* s)
{
	if (dpsctx)
		done();

	Display* display = Session::instance()->default_display();
	op_ = o;
	view_ = v;
	strm_ = s;
	raster_ = new Raster(display->to_pixels(view_->page_width()),
			    display->to_pixels(view_->page_height()));
	orient_ = view_->orientation();
	scale_ = view_->scale();
	page_ = view_->page();

	XDisplay* dpy = display->rep()->display_;
	XWindow pixmapID = raster_->rep()->pixmap_;
	extern int ourscreen;
	dpsctx = create_context(pixmapID, DefaultGC(dpy, ourscreen),
				raster_->pheight());
	if (dpsctx == NULL) {
		printf("wb: server doesn't support DPS\n");
		return (1);
	}
	interp = this;
	XDPSRegisterStatusProc(dpsctx, dps_stathandler);
	XDPSSetStatusMask(dpsctx, PSZOMBIEMASK|PSFROZENMASK,
			  PSNEEDSINPUTMASK|PSRUNNINGMASK, 0);

	/* set up a 1-1 coordinate transformation */
	double pt2pix = double(display->to_pixels(72000.)) * scale_ / 72000.;
	DPSPrintf(dpsctx, (char*)dpsinit, pt2pix, pt2pix, raster_->width(),
		  raster_->height(), -raster_->width());

	switch (orient_) {
	case 90:
		DPSPrintf(dpsctx,
		   "-90 rotate %g 0 translate wb$defmatrix currentmatrix pop\n",
		   -raster_->height() / scale_);
		break;
	case 270:
		DPSPrintf(dpsctx,
		    "90 rotate 0 %g translate wb$defmatrix currentmatrix pop\n",
		    -raster_->width() / scale_);
		break;
	}
	while (dpsctx) {
		const char* bp;
		int cc = strm_->read(bp);
		if (cc <= 0) {
			DPSPrintf(dpsctx, "\nshowpage\n");
			DPSFlushContext(dpsctx);
			break;
		}
		strm_->advance(cc);
		DPSWritePostScript(dpsctx, (char*)bp, cc);
	}
	return (dpsctx == 0);
}

void DPSinterp::done()
{
	if (dpsctx) {
		DPSDestroySpace(dpsctx->space);
		dpsctx = 0;
	}
	delete strm_;
	strm_ = 0;
}

DPSinterp::~DPSinterp()
{
	if (dpsctx)
		done();
}

void DPSinterp::page_done()
{
	interp = 0;
	op_->done(raster_, page_, view_, orient_, scale_);
	done();
}

int  DPSinterp::busy()
{
	if (dpsctx != 0) {
		if (view_->scale() == scale_ &&
		    view_->orientation() == orient_)
			return (1);
		/*
		 * dps may be wedged  - we're going to kill it anyway
		 * since window has changed geometry so kill it now.
		 */
		done();
	}
	return (0);

}
