# al-service-aries.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/aries/al-service-aries.tcl,v 1.5 2002/02/03 04:21:08 lim Exp $


import AnnounceListenManager/AS/Service AriesAgent

# AnnounceListenManager for the Aries AS1 recording service.
# <p> Status: pre-alpha <p> Author: Angela Schuett

Class AnnounceListenManager/AS/Service/Aries -superclass AnnounceListenManager/AS/Service


# On receipt of the first announcement, create an AriesAgent object, pass
# it the sdp message, which contains all the info necessary to start recording.
AnnounceListenManager/AS/Service/Aries public init {argv} {

	$self instvar serv_inst_ agent_

	#puts "***********************"
	#puts "$argv"
	#puts "***********************"

	set ssd [lindex $argv 0]
	set serv_inst_ [lindex $argv 1]
	set megactrl [lindex $argv 3]

	$self next $self $megactrl 20000 $serv_inst_


	set agent_ [new AriesAgent $self $ssd]

}

#
AnnounceListenManager/AS/Service/Aries public service_name {} {
	return Aries
}

# Return a list of ssrc's and error rates as our SSD
AnnounceListenManager/AS/Service/Aries public agent_data {} {
	$self instvar agent_
#puts "aries agent_data"
	return [$agent_ get_ssd]


}



# Recv a message, check if it's for us, and check if anything in the
# message has changed.  If not, then it's a keep alive message, and we
#  can ignore it.  If so, then pass the message in to the aries agent
AnnounceListenManager/AS/Service/Aries public recv_msg {atype aspec addr srv_name srv_loc srv_inst ssg_port ssd} {

	$self instvar serv_inst_

	if { $srv_name == "DEATH" } {
		puts stderr "Received death packet from $aspec at $addr - exiting."
		$self announce_death
		exit 0
	}
	$self next $atype $aspec $addr $srv_name $srv_loc $srv_inst $ssg_port $ssd

	if {$serv_inst_ != $srv_inst} {
		return
	}

	# check if the sdp message has changed

	# ??

}





AnnounceListenManager/AS/Service/Aries instproc unregister { atype aspec addr \
	        srv_name srv_inst msg } {

	$self instvar agentbytype_ srv_inst_ agenttab_ agent_
	if { $atype != "client" || $srv_inst != $srv_inst_ } {
		return
	}
	foreach aspec $agentbytype_(client) {
		set sid [lindex $agenttab_($aspec) 4]
		if { $sid == $srv_inst_ } {
			return
		}
	}

	$agent_ close
	puts stderr "Aries- no more clients -- exiting"
	exit 0

}
